/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.index.BoundingBox;
import org.dizitart.no2.mvstore.MVStoreConfig;
import org.dizitart.no2.mvstore.MVStoreUtils;
import org.dizitart.no2.mvstore.NitriteMVMap;
import org.dizitart.no2.mvstore.NitriteMVRTreeMap;
import org.dizitart.no2.store.AbstractNitriteStore;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteRTree;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.store.events.StoreEventListener;
import org.dizitart.no2.store.events.StoreEvents;
import org.h2.engine.Constants;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.rtree.MVRTreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NitriteMVStore
extends AbstractNitriteStore<MVStoreConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NitriteMVStore.class);
    private MVStore mvStore;
    private final Map<String, NitriteMap<?, ?>> nitriteMapRegistry = new ConcurrentHashMap();
    private final Map<String, NitriteRTree<?, ?>> nitriteRTreeMapRegistry = new ConcurrentHashMap();

    public void openOrCreate() {
        this.mvStore = MVStoreUtils.openOrCreate((MVStoreConfig)this.getStoreConfig());
        this.initEventBus();
        this.alert(StoreEvents.Opened);
    }

    public boolean isClosed() {
        return this.mvStore == null || this.mvStore.isClosed();
    }

    public boolean hasUnsavedChanges() {
        return this.mvStore != null && this.mvStore.hasUnsavedChanges();
    }

    public boolean isReadOnly() {
        return this.mvStore.isReadOnly();
    }

    public void commit() {
        this.mvStore.commit();
        this.alert(StoreEvents.Commit);
    }

    public void close() {
        for (NitriteMap<?, ?> nitriteMap : this.nitriteMapRegistry.values()) {
            nitriteMap.close();
        }
        for (NitriteRTree nitriteRTree : this.nitriteRTreeMapRegistry.values()) {
            nitriteRTree.close();
        }
        this.nitriteMapRegistry.clear();
        this.nitriteRTreeMapRegistry.clear();
        if (((MVStoreConfig)this.getStoreConfig()).autoCompact()) {
            this.mvStore.close(-1);
        } else {
            this.mvStore.close();
        }
        this.alert(StoreEvents.Closed);
        this.eventBus.close();
    }

    public boolean hasMap(String mapName) {
        return this.mvStore.hasMap(mapName);
    }

    public <Key, Value> NitriteMap<Key, Value> openMap(String mapName, Class<?> keyType, Class<?> valueType) {
        if (this.nitriteMapRegistry.containsKey(mapName)) {
            return (NitriteMVMap)this.nitriteMapRegistry.get(mapName);
        }
        MVMap mvMap = this.openMVMap(mapName, null);
        NitriteMVMap nitriteMVMap = new NitriteMVMap(mvMap, (NitriteStore<?>)this);
        this.nitriteMapRegistry.put(mapName, nitriteMVMap);
        return nitriteMVMap;
    }

    public void closeMap(String mapName) {
        if (!StringUtils.isNullOrEmpty((String)mapName)) {
            this.nitriteMapRegistry.remove(mapName);
        }
    }

    public void closeRTree(String rTreeName) {
        if (!StringUtils.isNullOrEmpty((String)rTreeName)) {
            this.nitriteRTreeMapRegistry.remove(rTreeName);
        }
    }

    public void removeMap(String name) {
        MVMap mvMap = this.openMVMap(name, null);
        this.mvStore.removeMap(mvMap);
        this.getCatalog().remove(name);
        this.nitriteMapRegistry.remove(name);
    }

    public void removeRTree(String rTreeName) {
        MVMap mvMap = this.openMVMap(rTreeName, (MVMap.MapBuilder)new MVRTreeMap.Builder());
        this.mvStore.removeMap(mvMap);
        this.getCatalog().remove(rTreeName);
        this.nitriteRTreeMapRegistry.remove(rTreeName);
    }

    public <Key extends BoundingBox, Value> NitriteRTree<Key, Value> openRTree(String mapName, Class<?> keyType, Class<?> valueType) {
        if (this.nitriteRTreeMapRegistry.containsKey(mapName)) {
            return (NitriteMVRTreeMap)this.nitriteRTreeMapRegistry.get(mapName);
        }
        MVRTreeMap map = (MVRTreeMap)this.openMVMap(mapName, (MVMap.MapBuilder)new MVRTreeMap.Builder());
        NitriteMVRTreeMap nitriteMVRTreeMap = new NitriteMVRTreeMap(map, (NitriteStore<?>)this);
        this.nitriteRTreeMapRegistry.put(mapName, nitriteMVRTreeMap);
        return nitriteMVRTreeMap;
    }

    public String getStoreVersion() {
        return "MVStore/" + Constants.VERSION;
    }

    private void initEventBus() {
        if (((MVStoreConfig)this.getStoreConfig()).eventListeners() != null) {
            for (StoreEventListener eventListener : ((MVStoreConfig)this.getStoreConfig()).eventListeners()) {
                this.eventBus.register((Object)eventListener);
            }
        }
    }

    private MVMap openMVMap(String mapName, MVMap.MapBuilder builder) {
        Throwable exception = null;
        try {
            MVMap.MapBuilder mapBuilder = builder == null ? new MVMap.Builder() : builder;
            long version = this.mvStore.getCurrentVersion();
            while (version >= 0L) {
                try {
                    return this.mvStore.openMap(mapName, mapBuilder);
                }
                catch (MVStoreException me) {
                    if (version == 0L) {
                        throw me;
                    }
                    log.warn("Error opening map {} with version {}, retrying with previous version", new Object[]{mapName, version, me});
                    if (me.getErrorCode() != 1 && me.getErrorCode() != 2 && me.getErrorCode() != 6 && me.getErrorCode() != 8 && me.getErrorCode() != 9 && me.getErrorCode() != 50) {
                        throw me;
                    }
                    this.mvStore.rollbackTo(version - 1L);
                    version = this.mvStore.getCurrentVersion();
                    exception = me;
                }
            }
        }
        catch (Exception e) {
            exception = e;
        }
        throw new NitriteIOException("Unable to open map " + mapName, exception);
    }
}

