/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore.compat.v1.mvstore;

import org.dizitart.no2.mvstore.compat.v1.mvstore.Page;

public class CursorPos {
    public Page page;
    public int index;
    public CursorPos parent;

    public CursorPos(Page page, int index, CursorPos parent) {
        this.page = page;
        this.index = index;
        this.parent = parent;
    }

    public static CursorPos traverseDown(Page page, Object key) {
        CursorPos cursorPos = null;
        while (!page.isLeaf()) {
            int index = page.binarySearch(key) + 1;
            if (index < 0) {
                index = -index;
            }
            cursorPos = new CursorPos(page, index, cursorPos);
            page = page.getChildPage(index);
        }
        return new CursorPos(page, page.binarySearch(key), cursorPos);
    }

    int processRemovalInfo(long version) {
        int unsavedMemory = 0;
        CursorPos head = this;
        while (head != null) {
            unsavedMemory += head.page.removePage(version);
            head = head.parent;
        }
        return unsavedMemory;
    }

    public String toString() {
        return "CursorPos{page=" + this.page + ", index=" + this.index + ", parent=" + this.parent + "}";
    }
}

