/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.rocksdb;

import java.lang.ref.Cleaner;
import java.util.Iterator;
import org.dizitart.no2.rocksdb.CleaningAction;
import org.dizitart.no2.rocksdb.Constants;
import org.dizitart.no2.rocksdb.formatter.ObjectFormatter;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksIterator;

class KeySet<K>
implements Iterable<K> {
    private final ObjectFormatter objectFormatter;
    private final RocksDB rocksDB;
    private final ColumnFamilyHandle columnFamilyHandle;
    private final Class<?> keyType;

    public KeySet(RocksDB rocksDB, ColumnFamilyHandle columnFamilyHandle, ObjectFormatter objectFormatter, Class<?> keyType) {
        this.rocksDB = rocksDB;
        this.columnFamilyHandle = columnFamilyHandle;
        this.objectFormatter = objectFormatter;
        this.keyType = keyType;
    }

    @Override
    public Iterator<K> iterator() {
        return new KeyIterator();
    }

    private class KeyIterator
    implements Iterator<K>,
    AutoCloseable {
        private final RocksIterator rawEntryIterator;
        private final Cleaner.Cleanable cleanable;

        public KeyIterator() {
            this.rawEntryIterator = KeySet.this.rocksDB.newIterator(KeySet.this.columnFamilyHandle);
            this.rawEntryIterator.seekToFirst();
            this.cleanable = Constants.CLEANER.register(this, new CleaningAction((AutoCloseable)this.rawEntryIterator));
        }

        @Override
        public boolean hasNext() {
            try {
                boolean result = this.rawEntryIterator.isValid();
                if (!result) {
                    this.rawEntryIterator.close();
                }
                return result;
            }
            catch (AssertionError e) {
                return false;
            }
        }

        @Override
        public K next() {
            Object key = KeySet.this.objectFormatter.decodeKey(this.rawEntryIterator.key(), KeySet.this.keyType);
            this.rawEntryIterator.next();
            return key;
        }

        @Override
        public void close() {
            this.cleanable.clean();
        }
    }
}

