/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.rocksdb;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.rocksdb.AbstractImmutableNativeReference;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.ComparatorOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.util.BytewiseComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBReference
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"nitrite-rocksdb");
    private Options options;
    private DBOptions dbOptions;
    private ColumnFamilyOptions columnFamilyOptions;
    private RocksDB rocksDB;
    private BytewiseComparator dbComparator = null;
    private List<ColumnFamilyDescriptor> columnFamilyDescriptors = new ArrayList<ColumnFamilyDescriptor>();
    private Map<String, ColumnFamilyHandle> columnFamilyHandleRegistry = new ConcurrentHashMap<String, ColumnFamilyHandle>();

    @Override
    public void close() throws RocksDBException {
        this.columnFamilyHandleRegistry.values().forEach(AbstractImmutableNativeReference::close);
        this.columnFamilyHandleRegistry.clear();
        this.rocksDB.closeE();
        this.dbOptions.close();
        this.dbComparator.close();
        this.columnFamilyOptions.close();
        this.options.close();
    }

    public synchronized ColumnFamilyHandle getOrCreateColumnFamily(String name) {
        if (this.columnFamilyHandleRegistry.containsKey(name)) {
            return this.columnFamilyHandleRegistry.get(name);
        }
        try {
            ColumnFamilyHandle handle = this.rocksDB.createColumnFamily(new ColumnFamilyDescriptor(name.getBytes(StandardCharsets.UTF_8), this.columnFamilyOptions));
            this.columnFamilyHandleRegistry.put(name, handle);
            return handle;
        }
        catch (RocksDBException e) {
            log.error("Error while retrieving column family handle", (Throwable)e);
            throw new NitriteIOException("Failed to obtain column family handle", (Throwable)e);
        }
    }

    public void dropColumnFamily(String mapName) {
        if (this.columnFamilyHandleRegistry.containsKey(mapName)) {
            try {
                ColumnFamilyHandle handle = this.columnFamilyHandleRegistry.get(mapName);
                this.rocksDB.dropColumnFamily(handle);
                handle.close();
                this.columnFamilyHandleRegistry.remove(mapName);
            }
            catch (RocksDBException e) {
                log.error("Error while dropping column family " + mapName, (Throwable)e);
                throw new NitriteIOException("Failed to drop column family", (Throwable)e);
            }
        }
    }

    public BytewiseComparator getDbComparator() {
        if (this.dbComparator == null) {
            this.dbComparator = new BytewiseComparator(new ComparatorOptions());
        }
        return this.dbComparator;
    }

    @Generated
    public Options getOptions() {
        return this.options;
    }

    @Generated
    public DBOptions getDbOptions() {
        return this.dbOptions;
    }

    @Generated
    public ColumnFamilyOptions getColumnFamilyOptions() {
        return this.columnFamilyOptions;
    }

    @Generated
    public RocksDB getRocksDB() {
        return this.rocksDB;
    }

    @Generated
    public List<ColumnFamilyDescriptor> getColumnFamilyDescriptors() {
        return this.columnFamilyDescriptors;
    }

    @Generated
    public Map<String, ColumnFamilyHandle> getColumnFamilyHandleRegistry() {
        return this.columnFamilyHandleRegistry;
    }

    @Generated
    public void setOptions(Options options) {
        this.options = options;
    }

    @Generated
    public void setDbOptions(DBOptions dbOptions) {
        this.dbOptions = dbOptions;
    }

    @Generated
    public void setColumnFamilyOptions(ColumnFamilyOptions columnFamilyOptions) {
        this.columnFamilyOptions = columnFamilyOptions;
    }

    @Generated
    public void setRocksDB(RocksDB rocksDB) {
        this.rocksDB = rocksDB;
    }

    @Generated
    public void setDbComparator(BytewiseComparator dbComparator) {
        this.dbComparator = dbComparator;
    }

    @Generated
    public void setColumnFamilyDescriptors(List<ColumnFamilyDescriptor> columnFamilyDescriptors) {
        this.columnFamilyDescriptors = columnFamilyDescriptors;
    }

    @Generated
    public void setColumnFamilyHandleRegistry(Map<String, ColumnFamilyHandle> columnFamilyHandleRegistry) {
        this.columnFamilyHandleRegistry = columnFamilyHandleRegistry;
    }
}

