/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.rocksdb;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.dizitart.no2.common.UnknownType;
import org.dizitart.no2.common.util.SpatialKey;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.exceptions.NitriteException;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.index.BoundingBox;
import org.dizitart.no2.rocksdb.RocksDBConfig;
import org.dizitart.no2.rocksdb.RocksDBMap;
import org.dizitart.no2.rocksdb.RocksDBRTree;
import org.dizitart.no2.rocksdb.RocksDBReference;
import org.dizitart.no2.rocksdb.RocksDBStoreUtils;
import org.dizitart.no2.store.AbstractNitriteStore;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteRTree;
import org.dizitart.no2.store.events.StoreEventListener;
import org.dizitart.no2.store.events.StoreEvents;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBStore
extends AbstractNitriteStore<RocksDBConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"nitrite-rocksdb");
    private final AtomicBoolean closed;
    private final Map<String, NitriteMap<?, ?>> nitriteMapRegistry = new ConcurrentHashMap();
    private final Map<String, NitriteRTree<?, ?>> nitriteRTreeMapRegistry = new ConcurrentHashMap();
    private RocksDBReference reference;

    public RocksDBStore() {
        this.closed = new AtomicBoolean(true);
    }

    public void openOrCreate() {
        try {
            if (this.closed.get()) {
                this.reference = RocksDBStoreUtils.openOrCreate((RocksDBConfig)this.getStoreConfig());
                this.closed.compareAndSet(true, false);
                this.initEventBus();
                this.alert(StoreEvents.Opened);
            }
        }
        catch (NitriteException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error while opening database", (Throwable)e);
            throw new NitriteIOException("Failed to open database", (Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean hasUnsavedChanges() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void commit() {
        this.alert(StoreEvents.Commit);
    }

    public void close() {
        try {
            if (!this.closed.get()) {
                for (NitriteMap<?, ?> nitriteMap : this.nitriteMapRegistry.values()) {
                    nitriteMap.close();
                }
                this.reference.close();
                this.closed.compareAndSet(false, true);
            }
            this.alert(StoreEvents.Closed);
            this.eventBus.close();
        }
        catch (Exception e) {
            log.error("Error while closing the database", (Throwable)e);
            throw new NitriteIOException("Failed to close database", (Throwable)e);
        }
    }

    public boolean hasMap(String mapName) {
        return this.reference.getColumnFamilyHandleRegistry().containsKey(mapName);
    }

    public <Key, Value> NitriteMap<Key, Value> openMap(String mapName, Class<?> keyType, Class<?> valueType) {
        if (this.nitriteMapRegistry.containsKey(mapName)) {
            RocksDBMap nitriteMap = (RocksDBMap)this.nitriteMapRegistry.get(mapName);
            if (UnknownType.class.equals(nitriteMap.getKeyType())) {
                nitriteMap.setKeyType(keyType);
            }
            if (UnknownType.class.equals(nitriteMap.getValueType())) {
                nitriteMap.setValueType(valueType);
            }
            return nitriteMap;
        }
        RocksDBMap nitriteMap = new RocksDBMap(mapName, this, this.reference, keyType, valueType);
        this.nitriteMapRegistry.put(mapName, nitriteMap);
        return nitriteMap;
    }

    public void closeMap(String mapName) {
        if (!StringUtils.isNullOrEmpty((String)mapName)) {
            this.nitriteMapRegistry.remove(mapName);
        }
    }

    public void removeMap(String mapName) {
        this.reference.dropColumnFamily(mapName);
        this.getCatalog().remove(mapName);
        this.nitriteMapRegistry.remove(mapName);
    }

    public <Key extends BoundingBox, Value> NitriteRTree<Key, Value> openRTree(String rTreeName, Class<?> keyType, Class<?> valueType) {
        if (this.nitriteRTreeMapRegistry.containsKey(rTreeName)) {
            return (RocksDBRTree)this.nitriteRTreeMapRegistry.get(rTreeName);
        }
        RocksDBMap nitriteMap = new RocksDBMap(rTreeName, this, this.reference, SpatialKey.class, keyType);
        RocksDBRTree nitriteRTree = new RocksDBRTree(nitriteMap);
        this.nitriteRTreeMapRegistry.put(rTreeName, nitriteRTree);
        return nitriteRTree;
    }

    public void closeRTree(String rTreeName) {
        if (!StringUtils.isNullOrEmpty((String)rTreeName)) {
            this.nitriteRTreeMapRegistry.remove(rTreeName);
        }
    }

    public void removeRTree(String mapName) {
        this.reference.dropColumnFamily(mapName);
        this.getCatalog().remove(mapName);
        this.nitriteRTreeMapRegistry.remove(mapName);
    }

    public String getStoreVersion() {
        return "RocksDB/" + RocksDBStore.getRocksDbVersion();
    }

    private void initEventBus() {
        if (((RocksDBConfig)this.getStoreConfig()).eventListeners() != null) {
            for (StoreEventListener eventListener : ((RocksDBConfig)this.getStoreConfig()).eventListeners()) {
                this.eventBus.register((Object)eventListener);
            }
        }
    }

    private static String getRocksDbVersion() {
        RocksDB.Version version = RocksDB.rocksdbVersion();
        return version.toString();
    }
}

