/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.rocksdb.formatter;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.io.Output;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.rocksdb.formatter.ComparableKeySerializer;
import org.dizitart.no2.rocksdb.formatter.KryoObjectFormatter;

class DefaultTimeKeySerializers {
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.ENGLISH);

    DefaultTimeKeySerializers() {
    }

    public static void registerAll(KryoObjectFormatter kryoObjectFormatter) {
        kryoObjectFormatter.registerSerializer(java.util.Date.class, new DateSerializer());
        kryoObjectFormatter.registerSerializer(Timestamp.class, new TimestampSerializer());
        kryoObjectFormatter.registerSerializer(Date.class, new SqlDateSerializer());
        kryoObjectFormatter.registerSerializer(Time.class, new TimeSerializer());
        kryoObjectFormatter.registerSerializer(GregorianCalendar.class, new GregorianCalendarSerializer());
    }

    private static class GregorianCalendarSerializer
    extends CalendarSerializer {
        private GregorianCalendarSerializer() {
        }
    }

    private static class CalendarSerializer
    extends ComparableKeySerializer<Calendar> {
        private CalendarSerializer() {
        }

        @Override
        protected void writeKeyInternal(Kryo kryo, Output output, Calendar object) {
            output.writeString(format.format(object.getTime()));
        }

        @Override
        protected Calendar readKeyInternal(Kryo kryo, String input, Class<Calendar> type) {
            try {
                Calendar cal = Calendar.getInstance();
                cal.setTime(format.parse(input));
                return cal;
            }
            catch (Exception e) {
                throw new NitriteIOException("Failed to read java.util.Date", (Throwable)e);
            }
        }
    }

    private static class TimeSerializer
    extends ComparableKeySerializer<Time> {
        private TimeSerializer() {
        }

        @Override
        public void writeKeyInternal(Kryo kryo, Output output, Time object) {
            output.writeString(format.format(object));
        }

        @Override
        public Time readKeyInternal(Kryo kryo, String value, Class<Time> type) {
            try {
                return new Time(format.parse(value).getTime());
            }
            catch (Exception e) {
                throw new NitriteIOException("Failed to read java.sql.Time", (Throwable)e);
            }
        }
    }

    private static class SqlDateSerializer
    extends ComparableKeySerializer<Date> {
        private SqlDateSerializer() {
        }

        @Override
        public void writeKeyInternal(Kryo kryo, Output output, Date object) {
            output.writeString(format.format(object));
        }

        @Override
        public Date readKeyInternal(Kryo kryo, String value, Class<Date> type) {
            try {
                return new Date(format.parse(value).getTime());
            }
            catch (Exception e) {
                throw new NitriteIOException("Failed to read java.sql.Date", (Throwable)e);
            }
        }
    }

    private static class TimestampSerializer
    extends ComparableKeySerializer<Timestamp> {
        private TimestampSerializer() {
        }

        @Override
        public void writeKeyInternal(Kryo kryo, Output output, Timestamp object) {
            output.writeString(format.format(object));
        }

        @Override
        public Timestamp readKeyInternal(Kryo kryo, String value, Class<Timestamp> type) {
            try {
                return new Timestamp(format.parse(value).getTime());
            }
            catch (Exception e) {
                throw new NitriteIOException("Failed to read java.sql.Timestamp", (Throwable)e);
            }
        }
    }

    private static class DateSerializer
    extends ComparableKeySerializer<java.util.Date> {
        private DateSerializer() {
        }

        @Override
        public void writeKeyInternal(Kryo kryo, Output output, java.util.Date object) {
            output.writeString(format.format(object));
        }

        @Override
        public java.util.Date readKeyInternal(Kryo kryo, String value, Class<java.util.Date> type) {
            try {
                return format.parse(value);
            }
            catch (Exception e) {
                throw new NitriteIOException("Failed to read java.util.Date", (Throwable)e);
            }
        }
    }
}

