/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.rocksdb.formatter;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.rocksdb.Constants;
import org.dizitart.no2.rocksdb.formatter.DefaultJavaSerializers;
import org.dizitart.no2.rocksdb.formatter.DefaultTimeKeySerializers;
import org.dizitart.no2.rocksdb.formatter.KryoKeySerializer;
import org.dizitart.no2.rocksdb.formatter.NitriteSerializers;
import org.dizitart.no2.rocksdb.formatter.ObjectFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoObjectFormatter
implements ObjectFormatter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"nitrite-rocksdb");
    private static final Kryo kryo = new Kryo();
    private final Map<Class<?>, KryoKeySerializer<?>> keySerializerRegistry = new HashMap();

    public KryoObjectFormatter() {
        kryo.setRegistrationRequired(false);
        this.registerInternalSerializers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> byte[] encode(T object) {
        byte[] byArray;
        if (object == null) {
            return Constants.DB_NULL;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            try (Output output = new Output((OutputStream)byteArrayOutputStream);){
                Kryo kryo = KryoObjectFormatter.kryo;
                synchronized (kryo) {
                    KryoObjectFormatter.kryo.writeObject(output, object);
                }
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new NitriteIOException("Failed to close output stream", (Throwable)e);
            }
        }
        byteArrayOutputStream.close();
        return byArray;
    }

    @Override
    public <T> byte[] encodeKey(T object) {
        byte[] byArray;
        if (object == null) {
            return Constants.DB_NULL;
        }
        Class<?> clazz = object.getClass();
        KryoKeySerializer<?> serializer = this.keySerializerRegistry.get(clazz);
        if (serializer == null) {
            return this.encode(object);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            try (Output output = new Output((OutputStream)byteArrayOutputStream);){
                serializer.writeKey(kryo, output, object);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new NitriteIOException("Failed to close output stream", (Throwable)e);
            }
        }
        byteArrayOutputStream.close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T decode(byte[] bytes, Class<T> type) {
        if (Arrays.equals(bytes, Constants.DB_NULL)) {
            return null;
        }
        try (Input input = new Input(bytes, 0, bytes.length);){
            Kryo kryo = KryoObjectFormatter.kryo;
            synchronized (kryo) {
                Object object = KryoObjectFormatter.kryo.readObject(input, type);
                return (T)object;
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T decodeKey(byte[] bytes, Class<T> type) {
        if (Arrays.equals(bytes, Constants.DB_NULL)) {
            return null;
        }
        KryoKeySerializer<?> serializer = this.keySerializerRegistry.get(type);
        if (serializer == null) {
            return this.decode(bytes, type);
        }
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
            Object obj;
            try (Input input = new Input((InputStream)byteArrayInputStream);){
                obj = serializer.readKey(kryo, input, type);
            }
            return (T)obj;
        }
        catch (IOException e) {
            throw new NitriteIOException("Failed to close output stream", (Throwable)e);
        }
    }

    public void registerSerializer(Class<?> type, Serializer<?> serializer) {
        if (serializer instanceof KryoKeySerializer) {
            KryoKeySerializer kryoKeySerializer = (KryoKeySerializer)serializer;
            if (kryoKeySerializer.registerToKryo()) {
                kryo.register(type, serializer);
            }
            this.keySerializerRegistry.put(type, kryoKeySerializer);
        } else {
            kryo.register(type, serializer);
        }
    }

    private void registerInternalSerializers() {
        try {
            NitriteSerializers.registerAll(this);
            DefaultJavaSerializers.registerAll(this);
            DefaultTimeKeySerializers.registerAll(this);
        }
        catch (Exception e) {
            log.error("Error while registering default serializers", (Throwable)e);
            throw new NitriteIOException("Failed to register default serializers", (Throwable)e);
        }
    }
}

