/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.rocksdb.formatter;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.serializers.JavaSerializer;
import com.esotericsoftware.kryo.kryo5.serializers.MapSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.DBValue;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.meta.Attributes;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.SpatialKey;
import org.dizitart.no2.index.BoundingBox;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.index.IndexMeta;
import org.dizitart.no2.rocksdb.formatter.ComparableKeySerializer;
import org.dizitart.no2.rocksdb.formatter.KryoObjectFormatter;
import org.dizitart.no2.store.UserCredential;

public class NitriteSerializers {
    public static void registerAll(KryoObjectFormatter kryoObjectFormatter) {
        kryoObjectFormatter.registerSerializer(NitriteId.class, new NitriteIdSerializer());
        kryoObjectFormatter.registerSerializer(Pair.class, new PairSerializer());
        kryoObjectFormatter.registerSerializer(Document.class, new DocumentSerializer());
        kryoObjectFormatter.registerSerializer(IndexMeta.class, new IndexMetaSerializer());
        kryoObjectFormatter.registerSerializer(IndexDescriptor.class, new IndexDescriptorSerializer());
        kryoObjectFormatter.registerSerializer(UserCredential.class, new UserCredentialSerializer());
        kryoObjectFormatter.registerSerializer(Attributes.class, new AttributesSerializer());
        kryoObjectFormatter.registerSerializer(Fields.class, new FieldsSerializer());
        kryoObjectFormatter.registerSerializer(DBValue.class, (Serializer<?>)new JavaSerializer());
        kryoObjectFormatter.registerSerializer(BoundingBox.class, new BoundingBoxSerializer());
        kryoObjectFormatter.registerSerializer(SpatialKey.class, new SpatialKeySerializer());
    }

    private static class SpatialKeySerializer
    extends Serializer<SpatialKey> {
        private SpatialKeySerializer() {
        }

        public void write(Kryo kryo, Output output, SpatialKey spatialKey) {
            output.writeLong(spatialKey.getId());
            kryo.writeObject(output, (Object)spatialKey.getMinMax());
        }

        public SpatialKey read(Kryo kryo, Input input, Class<? extends SpatialKey> aClass) {
            long id = input.readLong();
            float[] minMax = (float[])kryo.readObject(input, float[].class);
            return new SpatialKey(id, minMax);
        }
    }

    private static class BoundingBoxSerializer
    extends Serializer<BoundingBox> {
        private BoundingBoxSerializer() {
        }

        public void write(Kryo kryo, Output output, BoundingBox object) {
            output.writeFloat(object.getMinX());
            output.writeFloat(object.getMaxX());
            output.writeFloat(object.getMinY());
            output.writeFloat(object.getMaxY());
        }

        public BoundingBox read(Kryo kryo, Input input, Class<? extends BoundingBox> type) {
            float minX = input.readFloat();
            float maxX = input.readFloat();
            float minY = input.readFloat();
            float maxY = input.readFloat();
            return new BoundingBox(minX, maxX, minY, maxY);
        }
    }

    private static class FieldsSerializer
    extends Serializer<Fields> {
        private FieldsSerializer() {
        }

        public void write(Kryo kryo, Output output, Fields object) {
            kryo.writeObject(output, (Object)object.getFieldNames());
        }

        public Fields read(Kryo kryo, Input input, Class<? extends Fields> type) {
            List fieldNames = (List)kryo.readObject(input, ArrayList.class);
            return Fields.withNames((String[])fieldNames.toArray(new String[0]));
        }
    }

    private static class AttributesSerializer
    extends Serializer<Attributes> {
        private AttributesSerializer() {
        }

        public void write(Kryo kryo, Output output, Attributes object) {
            kryo.writeObject(output, (Object)object.getAttributes(), (Serializer)new MapSerializer());
        }

        public Attributes read(Kryo kryo, Input input, Class<? extends Attributes> type) {
            Map map = (Map)kryo.readObject(input, HashMap.class, (Serializer)new MapSerializer());
            Attributes attributes = new Attributes();
            attributes.setAttributes(map);
            return attributes;
        }
    }

    private static class UserCredentialSerializer
    extends Serializer<UserCredential> {
        private UserCredentialSerializer() {
        }

        public void write(Kryo kryo, Output output, UserCredential object) {
            output.writeInt(object.getPasswordHash().length);
            output.writeInt(object.getPasswordSalt().length);
            output.writeBytes(object.getPasswordHash());
            output.writeBytes(object.getPasswordSalt());
        }

        public UserCredential read(Kryo kryo, Input input, Class<? extends UserCredential> type) {
            int hashLength = input.readInt();
            int saltLength = input.readInt();
            byte[] hash = input.readBytes(hashLength);
            byte[] salt = input.readBytes(saltLength);
            UserCredential credential = new UserCredential();
            credential.setPasswordHash(hash);
            credential.setPasswordSalt(salt);
            return credential;
        }
    }

    private static class IndexDescriptorSerializer
    extends Serializer<IndexDescriptor> {
        private IndexDescriptorSerializer() {
        }

        public void write(Kryo kryo, Output output, IndexDescriptor object) {
            kryo.writeObject(output, (Object)object.getFields());
            output.writeString(object.getCollectionName());
            output.writeString(object.getIndexType());
        }

        public IndexDescriptor read(Kryo kryo, Input input, Class<? extends IndexDescriptor> type) {
            Fields fields = (Fields)kryo.readObject(input, Fields.class);
            String collectionName = input.readString();
            String indexType = input.readString();
            return new IndexDescriptor(indexType, fields, collectionName);
        }
    }

    private static class IndexMetaSerializer
    extends Serializer<IndexMeta> {
        private IndexMetaSerializer() {
        }

        public void write(Kryo kryo, Output output, IndexMeta object) {
            kryo.writeObject(output, (Object)object.getIndexDescriptor());
            output.writeString(object.getIndexMap());
            output.writeBoolean(object.getIsDirty().get());
        }

        public IndexMeta read(Kryo kryo, Input input, Class<? extends IndexMeta> type) {
            IndexDescriptor indexDescriptor = (IndexDescriptor)kryo.readObject(input, IndexDescriptor.class);
            String indexMap = input.readString();
            boolean isDirty = input.readBoolean();
            IndexMeta indexMeta = new IndexMeta();
            indexMeta.setIndexDescriptor(indexDescriptor);
            indexMeta.setIndexMap(indexMap);
            indexMeta.setIsDirty(new AtomicBoolean(isDirty));
            return indexMeta;
        }
    }

    private static class DocumentSerializer
    extends Serializer<Document> {
        private final MapSerializer mapSerializer = new MapSerializer(){

            protected Map create(Kryo kryo, Input input, Class type, int size) {
                return (Map)Document.createDocument();
            }
        };

        private DocumentSerializer() {
        }

        public void write(Kryo kryo, Output output, Document document) {
            this.mapSerializer.write(kryo, output, (Map)document);
        }

        public Document read(Kryo kryo, Input input, Class<? extends Document> type) {
            Document document = Document.createDocument();
            Map map = this.mapSerializer.read(kryo, input, Map.class);
            for (Map.Entry entry : map.entrySet()) {
                document.put((String)entry.getKey(), entry.getValue());
            }
            return document;
        }
    }

    private static class PairSerializer
    extends Serializer<Pair> {
        private PairSerializer() {
        }

        public void write(Kryo kryo, Output output, Pair entry) {
            kryo.writeClassAndObject(output, entry.getFirst());
            kryo.writeClassAndObject(output, entry.getSecond());
        }

        public Pair read(Kryo kryo, Input input, Class<? extends Pair> type) {
            Pair pair = new Pair();
            kryo.reference((Object)pair);
            Object key = kryo.readClassAndObject(input);
            pair.setFirst(key);
            Object value = kryo.readClassAndObject(input);
            pair.setSecond(value);
            return new Pair(key, value);
        }
    }

    private static class NitriteIdSerializer
    extends ComparableKeySerializer<NitriteId> {
        private NitriteIdSerializer() {
        }

        @Override
        protected void writeKeyInternal(Kryo kryo, Output output, NitriteId object) {
            output.writeString(object.getIdValue());
        }

        @Override
        protected NitriteId readKeyInternal(Kryo kryo, String input, Class<NitriteId> type) {
            return NitriteId.createId((String)input);
        }
    }
}

