/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.rocksdb;

import java.util.Iterator;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.rocksdb.formatter.ObjectFormatter;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksIterator;

class EntrySet<K, V>
implements Iterable<Pair<K, V>> {
    private final ObjectFormatter objectFormatter;
    private final RocksDB rocksDB;
    private final ColumnFamilyHandle columnFamilyHandle;
    private final Class<?> keyType;
    private final Class<?> valueType;
    private final boolean reverse;

    public EntrySet(RocksDB rocksDB, ColumnFamilyHandle columnFamilyHandle, ObjectFormatter objectFormatter, Class<?> keyType, Class<?> valueType, boolean reverse) {
        this.rocksDB = rocksDB;
        this.columnFamilyHandle = columnFamilyHandle;
        this.objectFormatter = objectFormatter;
        this.keyType = keyType;
        this.valueType = valueType;
        this.reverse = reverse;
    }

    @Override
    public Iterator<Pair<K, V>> iterator() {
        return new EntryIterator();
    }

    private class EntryIterator
    implements Iterator<Pair<K, V>> {
        private final RocksIterator rawEntryIterator;

        public EntryIterator() {
            this.rawEntryIterator = EntrySet.this.rocksDB.newIterator(EntrySet.this.columnFamilyHandle);
            if (EntrySet.this.reverse) {
                this.rawEntryIterator.seekToLast();
            } else {
                this.rawEntryIterator.seekToFirst();
            }
        }

        @Override
        public boolean hasNext() {
            try {
                boolean result = this.rawEntryIterator.isValid();
                if (!result) {
                    this.rawEntryIterator.close();
                }
                return result;
            }
            catch (AssertionError e) {
                return false;
            }
        }

        @Override
        public Pair<K, V> next() {
            Object key = EntrySet.this.objectFormatter.decodeKey(this.rawEntryIterator.key(), EntrySet.this.keyType);
            Object value = EntrySet.this.objectFormatter.decode(this.rawEntryIterator.value(), EntrySet.this.valueType);
            if (EntrySet.this.reverse) {
                this.rawEntryIterator.prev();
            } else {
                this.rawEntryIterator.next();
            }
            return new Pair(key, value);
        }
    }
}

