/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.rocksdb;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.rocksdb.EntrySet;
import org.dizitart.no2.rocksdb.KeySet;
import org.dizitart.no2.rocksdb.RocksDBConfig;
import org.dizitart.no2.rocksdb.RocksDBReference;
import org.dizitart.no2.rocksdb.RocksDBStore;
import org.dizitart.no2.rocksdb.ValueSet;
import org.dizitart.no2.rocksdb.formatter.ObjectFormatter;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksIterator;
import org.rocksdb.util.BytewiseComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBMap<K, V>
implements NitriteMap<K, V> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"nitrite-rocksdb");
    private final String mapName;
    private final RocksDBReference reference;
    private final RocksDBStore store;
    private AtomicLong size;
    private AtomicBoolean droppedFlag;
    private AtomicBoolean closedFlag;
    private RocksDB rocksDB;
    private ObjectFormatter objectFormatter;
    private ColumnFamilyHandle columnFamilyHandle;
    private BytewiseComparator bytewiseComparator;
    private Class<?> keyType;
    private Class<?> valueType;

    public RocksDBMap(String mapName, RocksDBStore store, RocksDBReference reference, Class<?> keyType, Class<?> valueType) {
        this.mapName = mapName;
        this.reference = reference;
        this.store = store;
        this.keyType = keyType;
        this.valueType = valueType;
        this.initialize();
    }

    public boolean containsKey(K k) {
        byte[] key = this.objectFormatter.encodeKey(k);
        try {
            boolean result = this.rocksDB.keyMayExist(this.columnFamilyHandle, key, null);
            if (!result) {
                return false;
            }
            return this.rocksDB.get(this.columnFamilyHandle, key) != null;
        }
        catch (Exception e) {
            log.error("Error while querying key", (Throwable)e);
            throw new NitriteIOException("Failed to check key", (Throwable)e);
        }
    }

    public V get(K k) {
        try {
            byte[] key = this.objectFormatter.encodeKey(k);
            byte[] value = this.rocksDB.get(this.columnFamilyHandle, key);
            if (value == null) {
                return null;
            }
            return (V)this.objectFormatter.decode(value, this.getValueType());
        }
        catch (Exception e) {
            log.error("Error while querying by key", (Throwable)e);
            throw new NitriteIOException("Failed to query by key", (Throwable)e);
        }
    }

    public NitriteStore<?> getStore() {
        return this.store;
    }

    public void clear() {
        this.reference.dropColumnFamily(this.mapName);
        this.columnFamilyHandle = this.reference.getOrCreateColumnFamily(this.mapName);
        this.size.set(0L);
        this.updateLastModifiedTime();
    }

    public String getName() {
        return this.mapName;
    }

    public RecordStream<V> values() {
        return RecordStream.fromIterable(new ValueSet(this.rocksDB, this.columnFamilyHandle, this.objectFormatter, this.getValueType()));
    }

    public V remove(K k) {
        try {
            byte[] key = this.objectFormatter.encodeKey(k);
            if (!this.rocksDB.keyMayExist(this.columnFamilyHandle, key, null)) {
                return null;
            }
            byte[] value = this.reference.getRocksDB().get(this.columnFamilyHandle, key);
            if (value == null) {
                return null;
            }
            this.reference.getRocksDB().delete(this.columnFamilyHandle, key);
            this.size.decrementAndGet();
            this.updateLastModifiedTime();
            return (V)this.objectFormatter.decode(value, this.getValueType());
        }
        catch (Exception e) {
            log.error("Error while removing key", (Throwable)e);
            throw new NitriteIOException("Failed to remove key", (Throwable)e);
        }
    }

    public RecordStream<K> keys() {
        return RecordStream.fromIterable(new KeySet(this.rocksDB, this.columnFamilyHandle, this.objectFormatter, this.getKeyType()));
    }

    public void put(K k, V v) {
        ValidationUtils.notNull(v, (String)"value cannot be null");
        try {
            byte[] key = this.objectFormatter.encodeKey(k);
            byte[] value = this.objectFormatter.encode(v);
            boolean result = this.rocksDB.keyMayExist(this.columnFamilyHandle, key, null);
            this.reference.getRocksDB().put(this.columnFamilyHandle, key, value);
            if (!result) {
                this.size.incrementAndGet();
            }
            this.updateLastModifiedTime();
        }
        catch (Exception e) {
            log.error("Error while writing key and value for " + this.mapName, (Throwable)e);
            throw new NitriteIOException("Failed to write key and value", (Throwable)e);
        }
    }

    public long size() {
        if (this.size.get() == 0L) {
            try (RocksIterator iterator = this.rocksDB.newIterator(this.columnFamilyHandle);){
                iterator.seekToFirst();
                while (iterator.isValid()) {
                    this.size.incrementAndGet();
                    iterator.next();
                }
            }
        }
        return this.size.get();
    }

    public V putIfAbsent(K k, V v) {
        ValidationUtils.notNull(v, (String)"value cannot be null");
        try {
            byte[] key = this.objectFormatter.encodeKey(k);
            byte[] oldValue = this.rocksDB.get(this.columnFamilyHandle, key);
            if (oldValue == null) {
                byte[] value = this.objectFormatter.encode(v);
                this.rocksDB.put(this.columnFamilyHandle, key, value);
                this.size.incrementAndGet();
                this.updateLastModifiedTime();
                return null;
            }
            return (V)this.objectFormatter.decode(oldValue, this.getValueType());
        }
        catch (Exception e) {
            log.error("Error while writing key and value", (Throwable)e);
            throw new NitriteIOException("Failed to write key and value", (Throwable)e);
        }
    }

    public RecordStream<Pair<K, V>> entries() {
        return RecordStream.fromIterable(new EntrySet(this.rocksDB, this.columnFamilyHandle, this.objectFormatter, this.getKeyType(), this.getValueType(), false));
    }

    public RecordStream<Pair<K, V>> reversedEntries() {
        return RecordStream.fromIterable(new EntrySet(this.rocksDB, this.columnFamilyHandle, this.objectFormatter, this.getKeyType(), this.getValueType(), true));
    }

    public K firstKey() {
        try (RocksIterator iterator = this.rocksDB.newIterator(this.columnFamilyHandle);){
            iterator.seekToFirst();
            if (iterator.isValid()) {
                byte[] key = iterator.key();
                Object obj = this.objectFormatter.decodeKey(key, this.getKeyType());
                return (K)obj;
            }
        }
        return null;
    }

    public K lastKey() {
        try (RocksIterator iterator = this.rocksDB.newIterator(this.columnFamilyHandle);){
            iterator.seekToLast();
            if (iterator.isValid()) {
                byte[] key = iterator.key();
                Object obj = this.objectFormatter.decodeKey(key, this.getKeyType());
                return (K)obj;
            }
        }
        return null;
    }

    public K higherKey(K k) {
        try (RocksIterator iterator = this.rocksDB.newIterator(this.columnFamilyHandle);){
            byte[] key = this.objectFormatter.encodeKey(k);
            iterator.seek(key);
            if (!iterator.isValid()) {
                iterator.seekToFirst();
            }
            ByteBuffer keyBuffer = ByteBuffer.wrap(key);
            while (iterator.isValid()) {
                byte[] nextKey = iterator.key();
                ByteBuffer nextKeyBuffer = ByteBuffer.wrap(nextKey);
                if (this.bytewiseComparator.compare(nextKeyBuffer, keyBuffer) > 0) {
                    Comparable k2;
                    Comparable comparable = k2 = (Comparable)this.objectFormatter.decodeKey(nextKey, k.getClass());
                    return (K)comparable;
                }
                iterator.next();
            }
        }
        return null;
    }

    public K ceilingKey(K k) {
        try (RocksIterator iterator = this.rocksDB.newIterator(this.columnFamilyHandle);){
            byte[] key = this.objectFormatter.encodeKey(k);
            iterator.seek(key);
            if (!iterator.isValid()) {
                iterator.seekToFirst();
            }
            ByteBuffer keyBuffer = ByteBuffer.wrap(key);
            while (iterator.isValid()) {
                byte[] nextKey = iterator.key();
                ByteBuffer nextKeyBuffer = ByteBuffer.wrap(nextKey);
                if (this.bytewiseComparator.compare(nextKeyBuffer, keyBuffer) >= 0) {
                    Comparable k2;
                    Comparable comparable = k2 = (Comparable)this.objectFormatter.decodeKey(nextKey, k.getClass());
                    return (K)comparable;
                }
                iterator.next();
            }
        }
        return null;
    }

    public K lowerKey(K k) {
        try (RocksIterator iterator = this.rocksDB.newIterator(this.columnFamilyHandle);){
            byte[] key = this.objectFormatter.encodeKey(k);
            iterator.seekForPrev(key);
            if (!iterator.isValid()) {
                iterator.seekToLast();
            }
            ByteBuffer keyBuffer = ByteBuffer.wrap(key);
            while (iterator.isValid()) {
                byte[] nextKey = iterator.key();
                ByteBuffer nextKeyBuffer = ByteBuffer.wrap(nextKey);
                if (this.bytewiseComparator.compare(nextKeyBuffer, keyBuffer) < 0) {
                    Comparable k2;
                    Comparable comparable = k2 = (Comparable)this.objectFormatter.decodeKey(nextKey, k.getClass());
                    return (K)comparable;
                }
                iterator.prev();
            }
        }
        return null;
    }

    public K floorKey(K k) {
        try (RocksIterator iterator = this.rocksDB.newIterator(this.columnFamilyHandle);){
            byte[] key = this.objectFormatter.encodeKey(k);
            iterator.seekForPrev(key);
            if (!iterator.isValid()) {
                iterator.seekToLast();
            }
            ByteBuffer keyBuffer = ByteBuffer.wrap(key);
            while (iterator.isValid()) {
                byte[] nextKey = iterator.key();
                ByteBuffer nextKeyBuffer = ByteBuffer.wrap(nextKey);
                if (this.bytewiseComparator.compare(nextKeyBuffer, keyBuffer) <= 0) {
                    Comparable k2;
                    Comparable comparable = k2 = (Comparable)this.objectFormatter.decodeKey(nextKey, k.getClass());
                    return (K)comparable;
                }
                iterator.prev();
            }
        }
        return null;
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public void drop() {
        if (!this.droppedFlag.get()) {
            this.droppedFlag.compareAndSet(false, true);
            this.closedFlag.compareAndSet(false, true);
            this.store.closeMap(this.getName());
            this.store.removeMap(this.getName());
        }
    }

    public boolean isDropped() {
        return this.droppedFlag.get();
    }

    public void close() {
        if (!this.closedFlag.get() && !this.droppedFlag.get()) {
            this.closedFlag.compareAndSet(false, true);
            this.store.closeMap(this.getName());
        }
    }

    public boolean isClosed() {
        return this.closedFlag.get();
    }

    private void initialize() {
        this.size = new AtomicLong(0L);
        this.closedFlag = new AtomicBoolean(false);
        this.droppedFlag = new AtomicBoolean(false);
        this.objectFormatter = ((RocksDBConfig)this.store.getStoreConfig()).objectFormatter();
        this.columnFamilyHandle = this.reference.getOrCreateColumnFamily(this.getName());
        this.rocksDB = this.reference.getRocksDB();
        this.bytewiseComparator = this.reference.getDbComparator();
    }

    @Generated
    public Class<?> getKeyType() {
        return this.keyType;
    }

    @Generated
    public void setKeyType(Class<?> keyType) {
        this.keyType = keyType;
    }

    @Generated
    public Class<?> getValueType() {
        return this.valueType;
    }

    @Generated
    public void setValueType(Class<?> valueType) {
        this.valueType = valueType;
    }
}

