/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.rocksdb;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.dizitart.no2.rocksdb.RocksDBConfig;
import org.dizitart.no2.rocksdb.RocksDBModule;
import org.dizitart.no2.rocksdb.formatter.ObjectFormatter;
import org.dizitart.no2.store.events.StoreEventListener;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;

public class RocksDBModuleBuilder {
    private String filePath;
    private Options options;
    private DBOptions dbOptions;
    private ColumnFamilyOptions columnFamilyOptions;
    private ObjectFormatter objectFormatter;
    private RocksDBConfig dbConfig = new RocksDBConfig();
    private final Set<StoreEventListener> eventListeners = new HashSet<StoreEventListener>();

    RocksDBModuleBuilder() {
    }

    public RocksDBModuleBuilder filePath(File file) {
        if (file != null) {
            this.filePath = file.getPath();
        }
        return this;
    }

    public RocksDBModuleBuilder filePath(String path) {
        this.filePath = path;
        return this;
    }

    public RocksDBModuleBuilder addStoreEventListener(StoreEventListener listener) {
        this.eventListeners.add(listener);
        return this;
    }

    public RocksDBModule build() {
        RocksDBModule module = new RocksDBModule(this.filePath());
        this.dbConfig.options(this.options());
        this.dbConfig.dbOptions(this.dbOptions());
        this.dbConfig.columnFamilyOptions(this.columnFamilyOptions());
        this.dbConfig.filePath(this.filePath());
        if (this.objectFormatter() != null) {
            this.dbConfig.objectFormatter(this.objectFormatter());
        }
        this.dbConfig.eventListeners(this.eventListeners());
        module.setStoreConfig(this.dbConfig);
        return module;
    }

    @Generated
    public String filePath() {
        return this.filePath;
    }

    @Generated
    public Options options() {
        return this.options;
    }

    @Generated
    public DBOptions dbOptions() {
        return this.dbOptions;
    }

    @Generated
    public ColumnFamilyOptions columnFamilyOptions() {
        return this.columnFamilyOptions;
    }

    @Generated
    public ObjectFormatter objectFormatter() {
        return this.objectFormatter;
    }

    @Generated
    public RocksDBConfig dbConfig() {
        return this.dbConfig;
    }

    @Generated
    public Set<StoreEventListener> eventListeners() {
        return this.eventListeners;
    }

    @Generated
    public RocksDBModuleBuilder options(Options options) {
        this.options = options;
        return this;
    }

    @Generated
    public RocksDBModuleBuilder dbOptions(DBOptions dbOptions) {
        this.dbOptions = dbOptions;
        return this;
    }

    @Generated
    public RocksDBModuleBuilder columnFamilyOptions(ColumnFamilyOptions columnFamilyOptions) {
        this.columnFamilyOptions = columnFamilyOptions;
        return this;
    }

    @Generated
    public RocksDBModuleBuilder objectFormatter(ObjectFormatter objectFormatter) {
        this.objectFormatter = objectFormatter;
        return this;
    }

    @Generated
    public RocksDBModuleBuilder dbConfig(RocksDBConfig dbConfig) {
        this.dbConfig = dbConfig;
        return this;
    }
}

