/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.rocksdb;

import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.util.SpatialKey;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.index.BoundingBox;
import org.dizitart.no2.rocksdb.RocksDBMap;
import org.dizitart.no2.store.NitriteRTree;

public class RocksDBRTree<Key extends BoundingBox, Value>
implements NitriteRTree<Key, Value> {
    private final RocksDBMap<SpatialKey, Key> backingMap;
    private final AtomicBoolean droppedFlag;
    private final AtomicBoolean closedFlag;

    public RocksDBRTree(RocksDBMap<SpatialKey, Key> backingMap) {
        this.backingMap = backingMap;
        this.closedFlag = new AtomicBoolean(false);
        this.droppedFlag = new AtomicBoolean(false);
    }

    public void add(Key key, NitriteId nitriteId) {
        this.checkOpened();
        if (nitriteId != null && nitriteId.getIdValue() != null) {
            SpatialKey spatialKey = this.getKey(key, Long.parseLong(nitriteId.getIdValue()));
            this.backingMap.put(spatialKey, key);
        }
    }

    public void remove(Key key, NitriteId nitriteId) {
        this.checkOpened();
        if (nitriteId != null && nitriteId.getIdValue() != null) {
            SpatialKey spatialKey = this.getKey(key, Long.parseLong(nitriteId.getIdValue()));
            this.backingMap.remove(spatialKey);
        }
    }

    public RecordStream<NitriteId> findIntersectingKeys(Key key) {
        this.checkOpened();
        SpatialKey spatialKey = this.getKey(key, 0L);
        HashSet<NitriteId> set = new HashSet<NitriteId>();
        for (SpatialKey sk : this.backingMap.keys()) {
            if (!this.isOverlap(sk, spatialKey)) continue;
            set.add(NitriteId.createId((String)Long.toString(sk.getId())));
        }
        return RecordStream.fromIterable(set);
    }

    public RecordStream<NitriteId> findContainedKeys(Key key) {
        this.checkOpened();
        SpatialKey spatialKey = this.getKey(key, 0L);
        HashSet<NitriteId> set = new HashSet<NitriteId>();
        for (SpatialKey sk : this.backingMap.keys()) {
            if (!this.isInside(sk, spatialKey)) continue;
            set.add(NitriteId.createId((String)Long.toString(sk.getId())));
        }
        return RecordStream.fromIterable(set);
    }

    public long size() {
        this.checkOpened();
        return this.backingMap.size();
    }

    public void close() {
        this.closedFlag.compareAndSet(false, true);
    }

    public void clear() {
        this.checkOpened();
        this.backingMap.clear();
    }

    public void drop() {
        this.checkOpened();
        this.droppedFlag.compareAndSet(false, true);
        this.backingMap.clear();
    }

    private SpatialKey getKey(Key key, long id) {
        if (key == null || key.equals((Object)BoundingBox.EMPTY)) {
            return new SpatialKey(id, new float[0]);
        }
        return new SpatialKey(id, new float[]{key.getMinX(), key.getMaxX(), key.getMinY(), key.getMaxY()});
    }

    private boolean isOverlap(SpatialKey a, SpatialKey b) {
        if (a.isNull() || b.isNull()) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            if (!(a.max(i) < b.min(i)) && !(a.min(i) > b.max(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isInside(SpatialKey a, SpatialKey b) {
        if (a.isNull() || b.isNull()) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            if (!(a.min(i) <= b.min(i)) && !(a.max(i) >= b.max(i))) continue;
            return false;
        }
        return true;
    }

    private void checkOpened() {
        if (this.closedFlag.get()) {
            throw new InvalidOperationException("RTreeMap is closed");
        }
        if (this.droppedFlag.get()) {
            throw new InvalidOperationException("RTreeMap is dropped");
        }
    }
}

