/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.rocksdb;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.rocksdb.RocksDBConfig;
import org.dizitart.no2.rocksdb.RocksDBReference;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StoreFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"nitrite-rocksdb");

    private StoreFactory() {
    }

    public static RocksDBReference createDBReference(RocksDBConfig dbConfig) {
        RocksDBReference reference = new RocksDBReference();
        StoreFactory.createOptions(reference, dbConfig);
        StoreFactory.createDbOptions(reference, dbConfig);
        StoreFactory.createColumnFamilyOptions(reference, dbConfig);
        StoreFactory.createColumnFamilyDescriptors(reference, dbConfig);
        StoreFactory.createRocksDB(reference, dbConfig);
        return reference;
    }

    private static void createOptions(RocksDBReference reference, RocksDBConfig dbConfig) {
        Options options = dbConfig.options();
        if (options == null) {
            options = new Options();
        }
        reference.setOptions(options);
    }

    private static void createDbOptions(RocksDBReference reference, RocksDBConfig dbConfig) {
        DBOptions dbOptions = dbConfig.dbOptions();
        if (dbOptions == null) {
            dbOptions = new DBOptions();
            dbOptions.setCreateIfMissing(true);
        }
        reference.setDbOptions(dbOptions);
    }

    private static void createColumnFamilyOptions(RocksDBReference reference, RocksDBConfig dbConfig) {
        ColumnFamilyOptions columnFamilyOptions = dbConfig.columnFamilyOptions();
        if (columnFamilyOptions == null) {
            columnFamilyOptions = new ColumnFamilyOptions();
            columnFamilyOptions.optimizeUniversalStyleCompaction();
        }
        reference.setColumnFamilyOptions(columnFamilyOptions);
    }

    private static void createColumnFamilyDescriptors(RocksDBReference reference, RocksDBConfig dbConfig) {
        ArrayList<ColumnFamilyDescriptor> cfDescriptors = new ArrayList<ColumnFamilyDescriptor>();
        cfDescriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, reference.getColumnFamilyOptions()));
        try {
            List columnFamilies = RocksDB.listColumnFamilies((Options)reference.getOptions(), (String)dbConfig.filePath());
            for (byte[] columnFamily : columnFamilies) {
                if (Arrays.equals(RocksDB.DEFAULT_COLUMN_FAMILY, columnFamily)) continue;
                cfDescriptors.add(new ColumnFamilyDescriptor(columnFamily, reference.getColumnFamilyOptions()));
            }
        }
        catch (RocksDBException e) {
            log.error("Error while listing column families", (Throwable)e);
            throw new NitriteIOException("Failed to open database", (Throwable)e);
        }
        reference.setColumnFamilyDescriptors(cfDescriptors);
    }

    private static void createRocksDB(RocksDBReference reference, RocksDBConfig dbConfig) {
        try {
            ArrayList columnFamilyHandleList = new ArrayList();
            RocksDB db = RocksDB.open((DBOptions)reference.getDbOptions(), (String)dbConfig.filePath(), reference.getColumnFamilyDescriptors(), columnFamilyHandleList);
            reference.setRocksDB(db);
            ConcurrentHashMap<String, ColumnFamilyHandle> handleMap = new ConcurrentHashMap<String, ColumnFamilyHandle>();
            for (ColumnFamilyHandle columnFamilyHandle : columnFamilyHandleList) {
                String name = new String(columnFamilyHandle.getName(), StandardCharsets.UTF_8);
                handleMap.put(name, columnFamilyHandle);
            }
            reference.setColumnFamilyHandleRegistry(handleMap);
        }
        catch (RocksDBException e) {
            log.error("Error while opening rocks database", (Throwable)e);
            throw new NitriteIOException("Failed to open database", (Throwable)e);
        }
    }
}

