/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.rocksdb;

import java.lang.ref.Cleaner;
import java.util.Iterator;
import org.dizitart.no2.rocksdb.CleaningAction;
import org.dizitart.no2.rocksdb.Constants;
import org.dizitart.no2.rocksdb.formatter.ObjectFormatter;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksIterator;

class ValueSet<V>
implements Iterable<V> {
    private final ObjectFormatter objectFormatter;
    private final RocksDB rocksDB;
    private final ColumnFamilyHandle columnFamilyHandle;
    private final Class<?> valueType;

    public ValueSet(RocksDB rocksDB, ColumnFamilyHandle columnFamilyHandle, ObjectFormatter objectFormatter, Class<?> valueType) {
        this.rocksDB = rocksDB;
        this.columnFamilyHandle = columnFamilyHandle;
        this.objectFormatter = objectFormatter;
        this.valueType = valueType;
    }

    @Override
    public Iterator<V> iterator() {
        return new ValueIterator();
    }

    private class ValueIterator
    implements Iterator<V>,
    AutoCloseable {
        private final RocksIterator rawEntryIterator;
        private final Cleaner.Cleanable cleanable;

        public ValueIterator() {
            this.rawEntryIterator = ValueSet.this.rocksDB.newIterator(ValueSet.this.columnFamilyHandle);
            this.rawEntryIterator.seekToFirst();
            this.cleanable = Constants.CLEANER.register(this, new CleaningAction((AutoCloseable)this.rawEntryIterator));
        }

        @Override
        public boolean hasNext() {
            try {
                boolean result = this.rawEntryIterator.isValid();
                if (!result) {
                    this.rawEntryIterator.close();
                }
                return result;
            }
            catch (AssertionError e) {
                return false;
            }
        }

        @Override
        public V next() {
            byte[] value = this.rawEntryIterator.value();
            this.rawEntryIterator.next();
            return ValueSet.this.objectFormatter.decode(value, ValueSet.this.valueType);
        }

        @Override
        public void close() {
            this.cleanable.clean();
        }
    }
}

