/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.rocksdb.formatter;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import org.dizitart.no2.rocksdb.formatter.KryoKeySerializer;

public abstract class ComparableKeySerializer<T extends Comparable<?>>
extends KryoKeySerializer<T> {
    private static final String NULL = "null";

    protected abstract void writeKeyInternal(Kryo var1, Output var2, T var3);

    protected abstract T readKeyInternal(Kryo var1, String var2, Class<T> var3);

    public void write(Kryo kryo, Output output, T object) {
        kryo.writeObject(output, object);
    }

    public T read(Kryo kryo, Input input, Class<? extends T> type) {
        return (T)((Comparable)kryo.readObject(input, type));
    }

    @Override
    public void writeKey(Kryo kryo, Output output, T object) {
        if (object == null) {
            output.writeString(NULL);
        } else {
            this.writeKeyInternal(kryo, output, object);
        }
    }

    @Override
    public T readKey(Kryo kryo, Input input, Class<T> type) {
        String value = input.readString();
        if (NULL.equals(value)) {
            return null;
        }
        return this.readKeyInternal(kryo, value, type);
    }
}

