/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import org.dizitart.no2.util.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ObjectId
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ObjectId.class);
    private static final long serialVersionUID = 3670079982654483072L;
    private static final int LOW_ORDER_THREE_BYTES = 0xFFFFFF;
    private static final int MACHINE_IDENTIFIER;
    private static final short PROCESS_IDENTIFIER;
    private static final AtomicInteger NEXT_COUNTER;
    private final int timestamp;
    private final int machineIdentifier;
    private final short processIdentifier;
    private final int counter;

    public static ObjectId get() {
        return new ObjectId();
    }

    ObjectId() {
        this(new Date());
    }

    private ObjectId(Date date) {
        this(ObjectId.dateToTimestampSeconds(date), MACHINE_IDENTIFIER, PROCESS_IDENTIFIER, NEXT_COUNTER.getAndIncrement(), false);
    }

    private ObjectId(int timestamp, int machineIdentifier, short processIdentifier, int counter, boolean checkCounter) {
        if ((machineIdentifier & 0xFF000000) != 0) {
            throw new IllegalArgumentException("The machine identifier must be between 0 and 16777215 (it must fit in three bytes).");
        }
        if (checkCounter && (counter & 0xFF000000) != 0) {
            throw new IllegalArgumentException("The counter must be between 0 and 16777215 (it must fit in three bytes).");
        }
        this.timestamp = timestamp;
        this.machineIdentifier = machineIdentifier;
        this.processIdentifier = processIdentifier;
        this.counter = counter & 0xFFFFFF;
    }

    private byte[] toByteArray() {
        byte[] bytes = new byte[]{ObjectId.int3(this.timestamp), ObjectId.int2(this.timestamp), ObjectId.int1(this.timestamp), ObjectId.int0(this.timestamp), ObjectId.int2(this.machineIdentifier), ObjectId.int1(this.machineIdentifier), ObjectId.int0(this.machineIdentifier), ObjectId.short1(this.processIdentifier), ObjectId.short0(this.processIdentifier), ObjectId.int2(this.counter), ObjectId.int1(this.counter), ObjectId.int0(this.counter)};
        return bytes;
    }

    Long toLong() {
        return ByteUtils.bytesToLong(this.toByteArray());
    }

    private static int createMachineIdentifier() {
        int machinePiece;
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                sb.append(ni.toString());
                byte[] mac = ni.getHardwareAddress();
                if (mac == null) continue;
                ByteBuffer bb = ByteBuffer.wrap(mac);
                try {
                    sb.append(bb.getChar());
                    sb.append(bb.getChar());
                    sb.append(bb.getChar());
                }
                catch (BufferUnderflowException bufferUnderflowException) {}
            }
            machinePiece = sb.toString().hashCode();
        }
        catch (Throwable t) {
            machinePiece = new SecureRandom().nextInt();
            log.warn("Failed to createId machine identifier from network interface, using random number instead", t);
        }
        return machinePiece &= 0xFFFFFF;
    }

    private static short createProcessIdentifier() {
        short processId;
        try {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            processId = processName.contains("@") ? (short)Integer.parseInt(processName.substring(0, processName.indexOf(64))) : (short)ManagementFactory.getRuntimeMXBean().getName().hashCode();
        }
        catch (Throwable t) {
            processId = (short)new SecureRandom().nextInt();
            log.warn("Failed to createId process identifier from JMX, using random number instead", t);
        }
        return processId;
    }

    private static int dateToTimestampSeconds(Date time) {
        return (int)(time.getTime() / 1000L);
    }

    private static byte int3(int x) {
        return (byte)(x >> 24);
    }

    private static byte int2(int x) {
        return (byte)(x >> 16);
    }

    private static byte int1(int x) {
        return (byte)(x >> 8);
    }

    private static byte int0(int x) {
        return (byte)x;
    }

    private static byte short1(short x) {
        return (byte)(x >> 8);
    }

    private static byte short0(short x) {
        return (byte)x;
    }

    static {
        NEXT_COUNTER = new AtomicInteger(new SecureRandom().nextInt());
        try {
            MACHINE_IDENTIFIER = ObjectId.createMachineIdentifier();
            PROCESS_IDENTIFIER = ObjectId.createProcessIdentifier();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

