/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.exceptions;

public class ErrorMessage {
    static final String PREFIX = "NO2.";
    private String message;
    private String errorCode;
    public static final ErrorMessage NO_USER_MAP_FOUND = new ErrorMessage("no user map found in the database", 7002);
    public static final ErrorMessage USER_MAP_SHOULD_NOT_EXISTS = new ErrorMessage("user map found unexpectedly", 7003);
    public static final ErrorMessage NULL_USER_CREDENTIAL = new ErrorMessage("no username or password is stored in the database", 7004);
    public static final ErrorMessage INVALID_USER_PASSWORD = new ErrorMessage("username or password is invalid", 7001);
    public static final ErrorMessage USER_ID_IS_EMPTY = new ErrorMessage("user id can not be empty", 7005);
    public static final ErrorMessage PASSWORD_IS_EMPTY = new ErrorMessage("password can not be empty", 7006);
    public static final ErrorMessage DATABASE_OPENED_IN_OTHER_PROCESS = new ErrorMessage("database is already opened in other process", 2001);
    public static final ErrorMessage UNABLE_TO_REPAIR_DB = new ErrorMessage("unable to repair database", 2002);
    public static final ErrorMessage UNABLE_TO_CREATE_IN_MEMORY_DB = new ErrorMessage("unable to create in-memory database", 2003);
    public static final ErrorMessage UNABLE_TO_CREATE_DB_FILE = new ErrorMessage("unable to create database file", 2013);
    public static final ErrorMessage STORE_IS_CLOSED = new ErrorMessage("store is closed", 2004);
    public static final ErrorMessage COLLECTION_IS_DROPPED = new ErrorMessage("collection has been dropped", 2005);
    public static final ErrorMessage IMPORT_READER_ERROR = new ErrorMessage("I/O error while creating parser from reader", 2007);
    public static final ErrorMessage IMPORT_READ_ERROR = new ErrorMessage("error while importing data", 2008);
    public static final ErrorMessage EXPORT_WRITER_ERROR = new ErrorMessage("I/O error while writing data with writer", 2010);
    public static final ErrorMessage EXPORT_WRITE_ERROR = new ErrorMessage("error while exporting data", 2011);
    public static final ErrorMessage INVALID_AND_FILTER = new ErrorMessage("invalid AND filter", 4001);
    public static final ErrorMessage VALUE_IS_NOT_COMPARABLE = new ErrorMessage("value is not comparable", 4002);
    public static final ErrorMessage NESTED_ELEM_MATCH_NOT_SUPPORTED = new ErrorMessage("nested elemMatch filter is not supported", 4003);
    public static final ErrorMessage FULL_TEXT_ELEM_MATCH_NOT_SUPPORTED = new ErrorMessage("full-text search is not supported in elemMatch filter", 4004);
    public static final ErrorMessage ELEM_MATCH_SUPPORTED_ON_ARRAY_ONLY = new ErrorMessage("elemMatch filter only applies to array or iterable", 4005);
    public static final ErrorMessage INVALID_OR_FILTER = new ErrorMessage("invalid OR filter", 4021);
    public static final ErrorMessage STAR_NOT_A_VALID_SEARCH_STRING = new ErrorMessage("* is not a valid search string", 4023);
    public static final ErrorMessage FILTERED_FIND_OPERATION_FAILED = new ErrorMessage("find operation failed", 4024);
    public static final ErrorMessage FILTERED_FIND_WITH_OPTIONS_OPERATION_FAILED = new ErrorMessage("find operation failed", 4025);
    public static final ErrorMessage NESTED_OBJ_ELEM_MATCH_NOT_SUPPORTED = new ErrorMessage("nested elemMatch filter is not supported", 4026);
    public static final ErrorMessage FULL_TEXT_OBJ_ELEM_MATCH_NOT_SUPPORTED = new ErrorMessage("full-text search is not supported in elemMatch filter", 4027);
    public static final ErrorMessage OBJ_ELEM_MATCH_SUPPORTED_ON_ARRAY_ONLY = new ErrorMessage("elemMatch filter only applies to array or iterable", 4028);
    public static final ErrorMessage CAN_NOT_SEARCH_NON_COMPARABLE_ON_INDEXED_FIELD = new ErrorMessage("can not search non-comparable value on indexed field", 4042);
    public static final ErrorMessage INVALID_SEARCH_TERM_LEADING_STAR = new ErrorMessage("invalid search term '*'", 4043);
    public static final ErrorMessage INVALID_SEARCH_TERM_TRAILING_STAR = new ErrorMessage("invalid search term '*'", 4044);
    public static final ErrorMessage MULTIPLE_WORDS_WITH_WILD_CARD = new ErrorMessage("multiple words with wildcard is not supported", 4045);
    public static final ErrorMessage NON_STRING_VALUE_IN_FULL_TEXT_INDEX = new ErrorMessage("value must be of string data type", 5004);
    public static final ErrorMessage FAILED_TO_QUERY_FTS_DATA = new ErrorMessage("could not search on full-text index", 5019);
    public static final ErrorMessage CAN_NOT_COMPARE_WITH_NULL_ID = new ErrorMessage("can not compare with null id", 6001);
    public static final ErrorMessage ID_CAN_NOT_BE_NULL = new ErrorMessage("id can not be null", 6003);
    public static final ErrorMessage ID_FILTER_VALUE_CAN_NOT_BE_NULL = new ErrorMessage("id value can not be null", 6007);
    public static final ErrorMessage ID_FIELD_IS_NOT_ACCESSIBLE = new ErrorMessage("id field is not accessible", 6004);
    public static final ErrorMessage FAILED_TO_CREATE_AUTO_ID = new ErrorMessage("failed to auto generate nitrite id", 6006);
    public static final ErrorMessage ID_VALUE_CAN_NOT_BE_EMPTY_STRING = new ErrorMessage("id value can not be empty string", 6005);
    public static final ErrorMessage PAGINATION_SIZE_CAN_NOT_BE_NEGATIVE = new ErrorMessage("pagination size can not be negative", 1001);
    public static final ErrorMessage PAGINATION_OFFSET_CAN_NOT_BE_NEGATIVE = new ErrorMessage("pagination offset can not be negative", 1002);
    public static final ErrorMessage PAGINATION_OFFSET_GREATER_THAN_SIZE = new ErrorMessage("pagination offset is greater than total size", 1003);
    public static final ErrorMessage REPOSITORY_NOT_INITIALIZED = new ErrorMessage("repository has not been initialized properly", 1004);
    public static final ErrorMessage CAN_NOT_PROJECT_TO_PRIMITIVE = new ErrorMessage("can not project to primitive type", 1005);
    public static final ErrorMessage CAN_NOT_PROJECT_TO_INTERFACE = new ErrorMessage("can not project to interface", 1006);
    public static final ErrorMessage CAN_NOT_PROJECT_TO_ARRAY = new ErrorMessage("can not project to array", 1007);
    public static final ErrorMessage CAN_NOT_PROJECT_TO_ABSTRACT = new ErrorMessage("can not project to abstract type", 1008);
    public static final ErrorMessage CAN_NOT_PROJECT_TO_EMPTY_TYPE = new ErrorMessage("can not project to empty type", 1009);
    public static final ErrorMessage SYNC_NO_REMOTE_COLLECTION = new ErrorMessage("remote collection is not set", 1010);
    public static final ErrorMessage OBJ_INVALID_EMBEDDED_FIELD = new ErrorMessage("invalid embedded field provided", 1078);
    public static final ErrorMessage INVALID_EMBEDDED_FIELD = new ErrorMessage("invalid embedded field provided", 1081);
    public static final ErrorMessage DOC_GET_TYPE_NULL = new ErrorMessage("type can not be null", 1081);
    public static final ErrorMessage UNABLE_TO_CREATE_IN_MEMORY_READONLY_DB = new ErrorMessage("unable create readonly in-memory database", 3001);
    public static final ErrorMessage FAILED_TO_CREATE_IN_MEMORY_READONLY_DB = new ErrorMessage("can not create readonly in-memory database", 2014);
    public static final ErrorMessage UNABLE_TO_SORT_ON_ARRAY = new ErrorMessage("can not sort on array or collection objects", 3002);
    public static final ErrorMessage REMOVE_ON_DOCUMENT_ITERATOR_NOT_SUPPORTED = new ErrorMessage("remove on cursor is not supported", 3003);
    public static final ErrorMessage OBJ_REMOVE_ON_OBJECT_ITERATOR_NOT_SUPPORTED = new ErrorMessage("remove on cursor is not supported", 3004);
    public static final ErrorMessage OBJ_REMOVE_ON_PROJECTED_OBJECT_ITERATOR_NOT_SUPPORTED = new ErrorMessage("remove on cursor is not supported", 3005);
    public static final ErrorMessage REPLICATOR_ALREADY_RUNNING = new ErrorMessage("replicator is already running", 3008);
    public static final ErrorMessage REMOVE_FAILED_AS_NO_ID_FOUND = new ErrorMessage("remove operation failed as no id value found for the document", 8001);
    public static final ErrorMessage UPDATE_FAILED_AS_NO_ID_FOUND = new ErrorMessage("update operation failed as no id value found for the document", 8005);
    public static final ErrorMessage OBJ_REMOVE_FAILED_AS_NO_ID_FOUND = new ErrorMessage("remove operation failed as no id value found for the object", 8002);
    public static final ErrorMessage OBJ_UPDATE_FAILED_AS_NO_ID_FOUND = new ErrorMessage("update operation failed as no id value found for the object", 8003);
    public static final ErrorMessage OBJ_MULTIPLE_ID_FOUND = new ErrorMessage("multiple id fields found for the type", 8004);
    public static final ErrorMessage JSON_SERIALIZATION_FAILED = new ErrorMessage("failed to serialize object to json", 9004);
    public static final ErrorMessage SYNC_ACCOUNT_CREATE_REMOTE_ERROR = new ErrorMessage("remote error while creating new sync user", 11002);
    public static final ErrorMessage SYNC_ACCOUNT_UPDATE_REMOTE_ERROR = new ErrorMessage("remote error while updating sync user", 11023);
    public static final ErrorMessage SYNC_GET_SIZE_REMOTE_ERROR = new ErrorMessage("remote error while getting size of collection", 11006);
    public static final ErrorMessage SYNC_CLEAR_REMOTE_ERROR = new ErrorMessage("remote error while clearing the collection", 11007);
    public static final ErrorMessage SYNC_FETCH_REMOTE_ERROR = new ErrorMessage("error while fetching documents from remote collection", 11009);
    public static final ErrorMessage SYNC_CHANGE_SINCE_REMOTE_ERROR = new ErrorMessage("error while fetching changes from remote collection", 11010);
    public static final ErrorMessage SYNC_CHANGE_REMOTE_ERROR = new ErrorMessage("error while submitting changes to remote collection", 11011);
    public static final ErrorMessage SYNC_TRY_LOCK_REMOTE_ERROR = new ErrorMessage("error while acquiring lock to remote collection", 11012);
    public static final ErrorMessage SYNC_RELEASE_LOCK_REMOTE_ERROR = new ErrorMessage("remote error while releasing lock from collection", 11014);

    private ErrorMessage(String message, int errorCode) {
        this.message = message;
        this.errorCode = PREFIX + errorCode;
    }

    public boolean isEqual(int code) {
        return this.errorCode.equals(PREFIX + code);
    }

    public static ErrorMessage errorMessage(String message, int errorCode) {
        return new ErrorMessage(message, errorCode);
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrorCode() {
        return this.errorCode;
    }
}

