/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import java.util.Set;
import org.dizitart.no2.Document;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.filters.StringFilter;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.StringUtils;

class TextFilter
extends StringFilter {
    TextFilter(String field, String value) {
        super(field, value);
    }

    @Override
    public Set<NitriteId> apply(NitriteMap<NitriteId, Document> documentMap) {
        if (this.nitriteService.hasIndex(this.field) && !this.nitriteService.isIndexing(this.field) && !StringUtils.isNullOrEmpty(this.value)) {
            return this.nitriteService.findTextWithIndex(this.field, this.value);
        }
        throw new IndexingException(ErrorMessage.errorMessage(this.field + " is not indexed", 5001));
    }

    public String toString() {
        return "TextFilter()";
    }
}

