/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.internals;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.dizitart.no2.Document;
import org.dizitart.no2.KeyValuePair;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.RecordIterable;
import org.dizitart.no2.Resettable;
import org.dizitart.no2.internals.DocumentIterator;
import org.dizitart.no2.internals.FindResult;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.EqualsUtils;
import org.dizitart.no2.util.Iterables;

class ProjectedDocumentIterable
implements RecordIterable<Document> {
    private final Set<NitriteId> resultSet;
    private final NitriteMap<NitriteId, Document> underlyingMap;
    private Document projection;
    private Iterator<Document> iterator;
    private boolean hasMore;
    private int totalCount;

    ProjectedDocumentIterable(Document projection, FindResult findResult) {
        this.projection = projection;
        this.resultSet = findResult.getIdSet() != null ? findResult.getIdSet() : new TreeSet<NitriteId>();
        this.underlyingMap = findResult.getUnderlyingMap();
        this.hasMore = findResult.isHasMore();
        this.totalCount = findResult.getTotalCount();
        this.iterator = new ProjectedDocumentIterator(this);
    }

    @Override
    public Iterator<Document> iterator() {
        return this.iterator;
    }

    @Override
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public int size() {
        return this.resultSet.size();
    }

    @Override
    public int totalCount() {
        return this.totalCount;
    }

    @Override
    public Document firstOrDefault() {
        Document item = Iterables.firstOrDefault(this);
        this.reset();
        return item;
    }

    @Override
    public List<Document> toList() {
        List<Document> list = Iterables.toList(this);
        this.reset();
        return list;
    }

    @Override
    public void reset() {
        this.iterator = new ProjectedDocumentIterator(this);
    }

    public String toString() {
        return this.toList().toString();
    }

    private class ProjectedDocumentIterator
    extends DocumentIterator {
        private Iterator<NitriteId> iterator;

        ProjectedDocumentIterator(Resettable<Document> resettable) {
            super(resettable);
            this.iterator = ProjectedDocumentIterable.this.resultSet.iterator();
            this.nextMatch();
        }

        @Override
        void nextMatch() {
            while (this.iterator.hasNext()) {
                NitriteId next = this.iterator.next();
                Document document = (Document)ProjectedDocumentIterable.this.underlyingMap.get(next);
                Document projected = this.project(document);
                if (projected == null) continue;
                this.nextElement = projected;
                return;
            }
            this.nextElement = null;
        }

        private Document project(Document original) {
            if (ProjectedDocumentIterable.this.projection == null) {
                return original;
            }
            Document result = new Document(original);
            for (KeyValuePair keyValuePair : original) {
                if (!ProjectedDocumentIterable.this.projection.containsKey(keyValuePair.getKey())) {
                    result.remove(keyValuePair.getKey());
                    continue;
                }
                if (ProjectedDocumentIterable.this.projection.get(keyValuePair.getKey()) == null || EqualsUtils.deepEquals(ProjectedDocumentIterable.this.projection.get(keyValuePair.getKey()), keyValuePair.getValue())) continue;
                return null;
            }
            return result;
        }
    }
}

