/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.internals;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import org.dizitart.no2.Cursor;
import org.dizitart.no2.Document;
import org.dizitart.no2.Filter;
import org.dizitart.no2.FindOptions;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.SortOrder;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.FilterException;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.internals.DocumentCursor;
import org.dizitart.no2.internals.FindResult;
import org.dizitart.no2.internals.NitriteService;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.DocumentUtils;
import org.dizitart.no2.util.StringUtils;
import org.dizitart.no2.util.ValidationUtils;

class SearchService {
    private NitriteService nitriteService;
    private NitriteMap<NitriteId, Document> underlyingMap;

    SearchService(NitriteService nitriteService, NitriteMap<NitriteId, Document> mapStore) {
        ValidationUtils.notNull(nitriteService, ErrorMessage.errorMessage("nitriteService can not be null", 1062));
        this.nitriteService = nitriteService;
        this.underlyingMap = mapStore;
    }

    Cursor find() {
        FindResult findResult = new FindResult();
        findResult.setHasMore(false);
        findResult.setTotalCount(this.underlyingMap.size());
        findResult.setIdSet(this.underlyingMap.keySet());
        findResult.setUnderlyingMap(this.underlyingMap);
        return new DocumentCursor(findResult);
    }

    Cursor find(Filter filter) {
        Set<NitriteId> result;
        filter.setNitriteService(this.nitriteService);
        try {
            result = filter.apply(this.underlyingMap);
        }
        catch (FilterException fe) {
            throw fe;
        }
        catch (Throwable t) {
            throw new FilterException(ErrorMessage.FILTERED_FIND_OPERATION_FAILED, t);
        }
        FindResult findResult = new FindResult();
        findResult.setUnderlyingMap(this.underlyingMap);
        if (result != null) {
            findResult.setHasMore(false);
            findResult.setTotalCount(result.size());
            findResult.setIdSet(result);
        }
        return new DocumentCursor(findResult);
    }

    Cursor find(FindOptions findOptions) {
        FindResult findResult = new FindResult();
        findResult.setUnderlyingMap(this.underlyingMap);
        this.setUnfilteredResultSet(findOptions, findResult);
        return new DocumentCursor(findResult);
    }

    Cursor find(Filter filter, FindOptions findOptions) {
        filter.setNitriteService(this.nitriteService);
        FindResult findResult = new FindResult();
        findResult.setUnderlyingMap(this.underlyingMap);
        this.setFilteredResultSet(filter, findOptions, findResult);
        return new DocumentCursor(findResult);
    }

    private void setUnfilteredResultSet(FindOptions findOptions, FindResult findResult) {
        ValidationUtils.validateLimit(findOptions, this.underlyingMap.sizeAsLong());
        Set<NitriteId> resultSet = StringUtils.isNullOrEmpty(findOptions.getField()) ? this.limitIdSet(this.underlyingMap.keySet(), findOptions) : this.sortIdSet(this.underlyingMap.keySet(), findOptions);
        findResult.setIdSet(resultSet);
        findResult.setTotalCount(this.underlyingMap.size());
        findResult.setHasMore(this.underlyingMap.keySet().size() > findOptions.getSize() + findOptions.getOffset());
    }

    private void setFilteredResultSet(Filter filter, FindOptions findOptions, FindResult findResult) {
        Set<NitriteId> nitriteIdSet;
        try {
            nitriteIdSet = filter.apply(this.underlyingMap);
        }
        catch (FilterException fe) {
            throw fe;
        }
        catch (Throwable t) {
            throw new FilterException(ErrorMessage.FILTERED_FIND_WITH_OPTIONS_OPERATION_FAILED, t);
        }
        if (nitriteIdSet == null || nitriteIdSet.isEmpty()) {
            return;
        }
        ValidationUtils.validateLimit(findOptions, nitriteIdSet.size());
        Set<NitriteId> resultSet = StringUtils.isNullOrEmpty(findOptions.getField()) ? this.limitIdSet(nitriteIdSet, findOptions) : this.sortIdSet(nitriteIdSet, findOptions);
        findResult.setIdSet(resultSet);
        findResult.setHasMore(nitriteIdSet.size() > findOptions.getSize() + findOptions.getOffset());
        findResult.setTotalCount(nitriteIdSet.size());
    }

    private Set<NitriteId> sortIdSet(Set<NitriteId> nitriteIdSet, FindOptions findOptions) {
        String sortField = findOptions.getField();
        TreeMap<Object, NitriteId> sortedMap = new TreeMap<Object, NitriteId>();
        for (NitriteId id : nitriteIdSet) {
            Document document = this.underlyingMap.get(id);
            Object value = DocumentUtils.getFieldValue(document, sortField);
            if (value == null) continue;
            if (value.getClass().isArray() || value instanceof Iterable) {
                throw new InvalidOperationException(ErrorMessage.UNABLE_TO_SORT_ON_ARRAY);
            }
            sortedMap.put(value, id);
        }
        Collection<NitriteId> sortedValues = findOptions.getSortOrder() == SortOrder.Ascending ? sortedMap.values() : sortedMap.descendingMap().values();
        return this.limitIdSet(sortedValues, findOptions);
    }

    private Set<NitriteId> limitIdSet(Collection<NitriteId> nitriteIdSet, FindOptions findOptions) {
        int offset = findOptions.getOffset();
        int size = findOptions.getSize();
        LinkedHashSet<NitriteId> resultSet = new LinkedHashSet<NitriteId>();
        int index = 0;
        for (NitriteId nitriteId : nitriteIdSet) {
            if (index >= offset) {
                resultSet.add(nitriteId);
                if (index == offset + size - 1) break;
            }
            ++index;
        }
        return resultSet;
    }
}

