/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.objects;

import java.util.Iterator;
import java.util.List;
import org.dizitart.no2.Document;
import org.dizitart.no2.RecordIterable;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.internals.NitriteMapper;
import org.dizitart.no2.objects.Cursor;
import org.dizitart.no2.objects.ProjectedObjectIterable;
import org.dizitart.no2.util.DocumentUtils;
import org.dizitart.no2.util.Iterables;
import org.dizitart.no2.util.ValidationUtils;

class ObjectCursor<T>
implements Cursor<T> {
    private org.dizitart.no2.Cursor cursor;
    private NitriteMapper nitriteMapper;
    private Class<T> type;
    private Iterator<T> cursorIterator;

    ObjectCursor(NitriteMapper nitriteMapper, org.dizitart.no2.Cursor cursor, Class<T> type) {
        this.nitriteMapper = nitriteMapper;
        this.cursor = cursor;
        this.type = type;
        this.cursorIterator = new ObjectCursorIterator(cursor.iterator());
    }

    @Override
    public <P> RecordIterable<P> project(Class<P> projectionType) {
        ValidationUtils.notNull(projectionType, ErrorMessage.errorMessage("projection can not be null", 1068));
        Document dummyDoc = DocumentUtils.emptyDocument(this.nitriteMapper, projectionType);
        return new ProjectedObjectIterable<P>(this.nitriteMapper, this.cursor.project(dummyDoc), projectionType);
    }

    @Override
    public boolean hasMore() {
        return this.cursor.hasMore();
    }

    @Override
    public int size() {
        return this.cursor.size();
    }

    @Override
    public int totalCount() {
        return this.cursor.totalCount();
    }

    @Override
    public T firstOrDefault() {
        Object item = Iterables.firstOrDefault(this);
        this.reset();
        return item;
    }

    @Override
    public List<T> toList() {
        List list = Iterables.toList(this);
        this.reset();
        return list;
    }

    @Override
    public Iterator<T> iterator() {
        return this.cursorIterator;
    }

    @Override
    public void reset() {
        this.cursor.reset();
        this.cursorIterator = new ObjectCursorIterator(this.cursor.iterator());
    }

    private class ObjectCursorIterator
    implements Iterator<T> {
        private Iterator<Document> documentIterator;

        ObjectCursorIterator(Iterator<Document> documentIterator) {
            this.documentIterator = documentIterator;
        }

        @Override
        public boolean hasNext() {
            return this.documentIterator.hasNext();
        }

        @Override
        public T next() {
            Document document = this.documentIterator.next();
            if (document != null) {
                return ObjectCursor.this.nitriteMapper.asObject(document, ObjectCursor.this.type);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new InvalidOperationException(ErrorMessage.OBJ_REMOVE_ON_OBJECT_ITERATOR_NOT_SUPPORTED);
        }
    }
}

