/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.objects;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dizitart.no2.Document;
import org.dizitart.no2.RecordIterable;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.internals.NitriteMapper;
import org.dizitart.no2.util.Iterables;

class ProjectedObjectIterable<T>
implements RecordIterable<T> {
    private RecordIterable<Document> recordIterable;
    private Class<T> projectionType;
    private ProjectedObjectIterator iterator;
    private NitriteMapper nitriteMapper;

    ProjectedObjectIterable(NitriteMapper nitriteMapper, RecordIterable<Document> recordIterable, Class<T> projectionType) {
        this.recordIterable = recordIterable;
        this.projectionType = projectionType;
        this.nitriteMapper = nitriteMapper;
        this.iterator = new ProjectedObjectIterator(nitriteMapper);
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator;
    }

    @Override
    public boolean hasMore() {
        return this.recordIterable.hasMore();
    }

    @Override
    public int size() {
        return this.recordIterable.size();
    }

    @Override
    public int totalCount() {
        return this.recordIterable.totalCount();
    }

    @Override
    public T firstOrDefault() {
        Object item = Iterables.firstOrDefault(this);
        this.reset();
        return item;
    }

    @Override
    public List<T> toList() {
        List list = Iterables.toList(this);
        this.reset();
        return list;
    }

    @Override
    public void reset() {
        this.recordIterable.reset();
        this.iterator = new ProjectedObjectIterator(this.nitriteMapper);
    }

    public String toString() {
        return this.toList().toString();
    }

    private class ProjectedObjectIterator
    implements Iterator<T> {
        private NitriteMapper objectMapper;

        ProjectedObjectIterator(NitriteMapper nitriteMapper) {
            this.objectMapper = nitriteMapper;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = true;
            try {
                boolean bl = hasNext = ProjectedObjectIterable.this.recordIterable.iterator().hasNext();
                return bl;
            }
            finally {
                if (!hasNext) {
                    ProjectedObjectIterable.this.reset();
                }
            }
        }

        @Override
        public T next() {
            Document record = new Document((Map)ProjectedObjectIterable.this.recordIterable.iterator().next());
            record.remove("_id");
            return this.objectMapper.asObject(record, ProjectedObjectIterable.this.projectionType);
        }

        @Override
        public void remove() {
            throw new InvalidOperationException(ErrorMessage.OBJ_REMOVE_ON_PROJECTED_OBJECT_ITERATOR_NOT_SUPPORTED);
        }
    }
}

