/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.util;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.dizitart.no2.Document;
import org.dizitart.no2.Filter;
import org.dizitart.no2.KeyValuePair;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.ValidationException;
import org.dizitart.no2.filters.Filters;
import org.dizitart.no2.internals.NitriteMapper;
import org.dizitart.no2.util.ObjectUtils;
import org.dizitart.no2.util.StringUtils;

public final class DocumentUtils {
    static String FIELD_SEPARATOR = ".";

    public static Set<String> getFields(Document document) {
        return DocumentUtils.getFieldsInternal(document, "");
    }

    public static Object getFieldValue(Document document, String field) {
        Object fieldValue = field.contains(FIELD_SEPARATOR) ? DocumentUtils.getEmbeddedValue(document, field) : document.get(field);
        return fieldValue;
    }

    public static <T> Document emptyDocument(NitriteMapper nitriteMapper, Class<T> type) {
        if (type.isPrimitive()) {
            throw new ValidationException(ErrorMessage.CAN_NOT_PROJECT_TO_PRIMITIVE);
        }
        if (type.isInterface()) {
            throw new ValidationException(ErrorMessage.CAN_NOT_PROJECT_TO_INTERFACE);
        }
        if (type.isArray()) {
            throw new ValidationException(ErrorMessage.CAN_NOT_PROJECT_TO_ARRAY);
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new ValidationException(ErrorMessage.CAN_NOT_PROJECT_TO_ABSTRACT);
        }
        Document dummyDoc = DocumentUtils.dummyDocument(nitriteMapper, type);
        Document filtered = DocumentUtils.removeValues(dummyDoc);
        if (filtered == null) {
            throw new ValidationException(ErrorMessage.CAN_NOT_PROJECT_TO_EMPTY_TYPE);
        }
        return filtered;
    }

    public static boolean isRecent(Document recent, Document older) {
        if (recent.getRevision() == older.getRevision()) {
            return recent.getLastModifiedTime() >= older.getLastModifiedTime();
        }
        return recent.getRevision() > older.getRevision();
    }

    public static Filter createUniqueFilter(Document document) {
        return Filters.eq("_id", document.getId().getIdValue());
    }

    static <T> Document dummyDocument(NitriteMapper nitriteMapper, Class<T> type) {
        T dummy = ObjectUtils.newInstance(type);
        return nitriteMapper.asDocument(dummy);
    }

    private static Set<String> getFieldsInternal(Document document, String prefix) {
        TreeSet<String> fields = new TreeSet<String>();
        if (document == null) {
            return fields;
        }
        for (KeyValuePair entry : document) {
            Object value = entry.getValue();
            if (value instanceof Document) {
                if (StringUtils.isNullOrEmpty(prefix)) {
                    fields.addAll(DocumentUtils.getFieldsInternal((Document)value, entry.getKey()));
                    continue;
                }
                fields.addAll(DocumentUtils.getFieldsInternal((Document)value, prefix + FIELD_SEPARATOR + entry.getKey()));
                continue;
            }
            if (value instanceof Iterable) continue;
            if (StringUtils.isNullOrEmpty(prefix)) {
                fields.add(entry.getKey());
                continue;
            }
            fields.add(prefix + FIELD_SEPARATOR + entry.getKey());
        }
        return fields;
    }

    private static Object getEmbeddedValue(Document document, String embeddedField) {
        String regex = "\\" + FIELD_SEPARATOR;
        String[] split = embeddedField.split(regex, 2);
        String key = split[0];
        if (StringUtils.isNullOrEmpty(key)) {
            throw new ValidationException(ErrorMessage.INVALID_EMBEDDED_FIELD);
        }
        Object object = document.get(key);
        if (object == null) {
            return null;
        }
        String remainingKey = split[1];
        if (object instanceof Document) {
            return DocumentUtils.getFieldValue((Document)object, remainingKey);
        }
        if (object instanceof List) {
            int index = DocumentUtils.asInteger(remainingKey);
            if (index == -1) {
                throw new ValidationException(ErrorMessage.errorMessage("invalid index " + remainingKey + " for collection", 1082));
            }
            List collection = (List)object;
            if (index >= collection.size()) {
                throw new ValidationException(ErrorMessage.errorMessage("index = " + remainingKey + " is not less than the size of the collection '" + key + "' = " + collection.size(), 1083));
            }
            return collection.get(index);
        }
        if (object.getClass().isArray()) {
            int index = DocumentUtils.asInteger(remainingKey);
            if (index == -1) {
                throw new ValidationException(ErrorMessage.errorMessage("invalid index " + remainingKey + " for collection", 1084));
            }
            Object[] array = DocumentUtils.getArray(object);
            if (index >= array.length) {
                throw new ValidationException(ErrorMessage.errorMessage("index = " + remainingKey + " is not less than the size of the collection '" + key + "' = " + array.length, 1085));
            }
            return array[index];
        }
        throw new ValidationException(ErrorMessage.errorMessage("invalid remaining field " + remainingKey, 1086));
    }

    private static int asInteger(String number) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static Object[] getArray(Object val) {
        int length = Array.getLength(val);
        Object[] outputArray = new Object[length];
        for (int i = 0; i < length; ++i) {
            outputArray[i] = Array.get(val, i);
        }
        return outputArray;
    }

    private static Document removeValues(Document dummyDoc) {
        if (dummyDoc == null) {
            return null;
        }
        for (KeyValuePair entry : dummyDoc) {
            if (entry.getValue() instanceof Map) {
                dummyDoc.put(entry.getKey(), (Object)DocumentUtils.removeValues((Document)entry.getValue()));
                continue;
            }
            dummyDoc.put(entry.getKey(), (Object)null);
        }
        return dummyDoc;
    }

    private DocumentUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

