/*
 * Copyright 2017 Nitrite author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.dizitart.no2.sync;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * Represents the event data for a replication event.
 *
 * @since 1.0
 * @author Anindya Chatterjee.
 */
@Getter @Setter
public class SyncEventData implements Serializable {
    /**
     * Indicates the source collection name.
     *
     * @param collectionName source collection name
     * @return collection name.
     * */
    private String collectionName;

    /**
     * Indicates the replication {@link EventType}.
     *
     * @param eventType replication event type
     * @return replication event type.
     * */
    private EventType eventType;

    /**
     * Indicates error during replication.
     *
     * @param error replication error
     * @return error in replication.
     * */
    private Throwable error;
}
