/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.sync;

import java.util.concurrent.ScheduledExecutorService;
import org.dizitart.no2.IndexOptions;
import org.dizitart.no2.IndexType;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.NitriteCollection;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.objects.ObjectRepository;
import org.dizitart.no2.sync.CollectionReplicator;
import org.dizitart.no2.sync.LocalCollection;
import org.dizitart.no2.sync.RemoveLogWriter;
import org.dizitart.no2.sync.ReplicationType;
import org.dizitart.no2.sync.SyncConfig;
import org.dizitart.no2.sync.SyncEventBus;
import org.dizitart.no2.sync.SyncEventListener;
import org.dizitart.no2.sync.SyncHandle;
import org.dizitart.no2.sync.SyncService;
import org.dizitart.no2.sync.SyncTemplate;
import org.dizitart.no2.sync.TimeSpan;
import org.dizitart.no2.util.ValidationUtils;

public class Replicator {
    public static CollectionSyncBuilder of(Nitrite db) {
        CollectionSyncBuilder builder = new CollectionSyncBuilder();
        builder.db = db;
        return builder;
    }

    public static class SyncHandleBuilder {
        private Nitrite db;
        private NitriteCollection collection;
        private SyncTemplate syncTemplate;
        private ReplicationType replicationType;
        private TimeSpan syncDelay;
        private SyncEventListener listener;

        public SyncHandleBuilder withSyncTemplate(SyncTemplate syncTemplate) {
            this.syncTemplate = syncTemplate;
            return this;
        }

        public SyncHandleBuilder ofType(ReplicationType replicationType) {
            this.replicationType = replicationType;
            return this;
        }

        public SyncHandleBuilder delay(TimeSpan syncDelay) {
            this.syncDelay = syncDelay;
            return this;
        }

        public SyncHandleBuilder withListener(SyncEventListener listener) {
            this.listener = listener;
            return this;
        }

        public SyncHandle configure() {
            SyncConfig syncConfig = new SyncConfig();
            syncConfig.setSyncTemplate(this.syncTemplate);
            syncConfig.setReplicationType(this.replicationType);
            syncConfig.setSyncDelay(this.syncDelay);
            syncConfig.setSyncEventListener(this.listener);
            SyncEventBus eventBus = new SyncEventBus(this.db.getContext());
            NitriteCollection changeLogRepository = this.db.getCollection("removeLog");
            ScheduledExecutorService replicatorPool = this.db.getContext().getScheduledWorkerPool();
            ValidationUtils.notNull(this.collection, ErrorMessage.errorMessage("collection can not be null", 1063));
            String uniqueName = this.collection.getName();
            RemoveLogWriter removeLogWriter = new RemoveLogWriter(changeLogRepository);
            removeLogWriter.setCollection(uniqueName);
            this.collection.register(removeLogWriter);
            SyncService syncService = new SyncService();
            if (this.collection instanceof ObjectRepository) {
                this.collection = ((ObjectRepository)((Object)this.collection)).getDocumentCollection();
            }
            syncService.setSyncConfig(syncConfig);
            syncService.setChangeLogRepository(changeLogRepository);
            syncService.setLocalCollection(new LocalCollection(this.collection));
            syncService.setSyncEventBus(eventBus);
            CollectionReplicator replicator = new CollectionReplicator();
            replicator.setSyncService(syncService);
            replicator.setReplicationType(syncConfig.getReplicationType());
            SyncHandle syncHandle = new SyncHandle(syncConfig);
            syncHandle.setReplicatorPool(replicatorPool);
            syncHandle.setSyncService(syncService);
            syncHandle.setReplicator(replicator);
            SyncEventListener listener = syncConfig.getSyncEventListener();
            if (listener != null) {
                listener.setCollectionName(uniqueName);
                eventBus.register(listener);
            }
            if (!this.collection.hasIndex("_revision") && !this.collection.isIndexing("_revision")) {
                this.collection.createIndex("_revision", IndexOptions.indexOptions(IndexType.NonUnique, true));
            }
            return syncHandle;
        }
    }

    public static class CollectionSyncBuilder {
        private Nitrite db;

        public SyncHandleBuilder forLocal(NitriteCollection collection) {
            SyncHandleBuilder syncHandleBuilder = new SyncHandleBuilder();
            syncHandleBuilder.db = this.db;
            syncHandleBuilder.collection = collection;
            return syncHandleBuilder;
        }

        public <T> SyncHandleBuilder forLocal(ObjectRepository<T> repository) {
            SyncHandleBuilder syncHandleBuilder = new SyncHandleBuilder();
            syncHandleBuilder.db = this.db;
            syncHandleBuilder.collection = repository.getDocumentCollection();
            return syncHandleBuilder;
        }
    }
}

