/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dizitart.no2.KeyValuePair;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.InvalidIdException;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.exceptions.ValidationException;
import org.dizitart.no2.util.ValidationUtils;

public class Document
extends LinkedHashMap<String, Object>
implements Iterable<KeyValuePair> {
    private static final long serialVersionUID = 1477462374L;

    public Document() {
    }

    public Document(Map<String, Object> map) {
        super(map);
    }

    public static Document createDocument(String key, Object value) {
        Document document = new Document();
        document.put(key, value);
        return document;
    }

    @Override
    public Document put(String key, Object value) {
        if ("_id".contentEquals(key) && !this.validId(value)) {
            throw new InvalidOperationException(ErrorMessage.errorMessage("document id is an auto generated value and can not be " + value, 3009));
        }
        if (value != null && !Serializable.class.isAssignableFrom(value.getClass())) {
            throw new ValidationException(ErrorMessage.errorMessage("type " + value.getClass().getName() + " does not implement java.io.Serializable", 1083));
        }
        super.put(key, value);
        return this;
    }

    public Object get(String key) {
        return super.get(key);
    }

    public <T> T get(String key, Class<T> type) {
        ValidationUtils.notNull(type, ErrorMessage.DOC_GET_TYPE_NULL);
        return type.cast(super.get(key));
    }

    public NitriteId getId() {
        Long id = null;
        try {
            if (!this.containsKey("_id")) {
                id = NitriteId.newId().getIdValue();
                super.put("_id", id);
            } else {
                id = (Long)this.get("_id");
            }
            return NitriteId.createId(id);
        }
        catch (ClassCastException cce) {
            throw new InvalidIdException(ErrorMessage.errorMessage("invalid _id found " + id, 6002));
        }
    }

    public int getRevision() {
        if (!this.containsKey("_revision")) {
            return 0;
        }
        return this.get("_revision", Integer.class);
    }

    public String getSource() {
        if (!this.containsKey("_source")) {
            return "";
        }
        return this.get("_source", String.class);
    }

    public long getLastModifiedTime() {
        if (!this.containsKey("_modified")) {
            return 0L;
        }
        return this.get("_modified", Long.class);
    }

    @Override
    public Iterator<KeyValuePair> iterator() {
        return new PairIterator(super.entrySet().iterator());
    }

    private boolean validId(Object value) {
        return value instanceof Long;
    }

    private class PairIterator
    implements Iterator<KeyValuePair> {
        private Iterator<Map.Entry<String, Object>> iterator;

        PairIterator(Iterator<Map.Entry<String, Object>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public KeyValuePair next() {
            Map.Entry<String, Object> next = this.iterator.next();
            return new KeyValuePair(next.getKey(), next.getValue());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

