/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.internals;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.dizitart.no2.Cursor;
import org.dizitart.no2.Document;
import org.dizitart.no2.Lookup;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.RecordIterable;
import org.dizitart.no2.Resettable;
import org.dizitart.no2.internals.DocumentIterator;
import org.dizitart.no2.internals.FindResult;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.EqualsUtils;
import org.dizitart.no2.util.Iterables;

class JoinedDocumentIterable
implements RecordIterable<Document> {
    private final Set<NitriteId> resultSet;
    private final NitriteMap<NitriteId, Document> underlyingMap;
    private boolean hasMore;
    private int totalCount;
    private Iterator<Document> iterator;
    private Cursor foreignCursor;
    private Lookup lookup;

    JoinedDocumentIterable(FindResult findResult, Cursor foreignCursor, Lookup lookup) {
        this.foreignCursor = foreignCursor;
        this.lookup = lookup;
        this.resultSet = findResult.getIdSet() != null ? findResult.getIdSet() : new TreeSet<NitriteId>();
        this.underlyingMap = findResult.getUnderlyingMap();
        this.hasMore = findResult.isHasMore();
        this.totalCount = findResult.getTotalCount();
        this.iterator = new JoinedDocumentIterator(this);
    }

    @Override
    public void reset() {
        this.iterator = new JoinedDocumentIterator(this);
    }

    @Override
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public int size() {
        return this.resultSet.size();
    }

    @Override
    public int totalCount() {
        return this.totalCount;
    }

    @Override
    public Document firstOrDefault() {
        Document item = Iterables.firstOrDefault(this);
        this.reset();
        return item;
    }

    @Override
    public List<Document> toList() {
        List<Document> list = Iterables.toList(this);
        this.reset();
        return list;
    }

    @Override
    public Iterator<Document> iterator() {
        return this.iterator;
    }

    public String toString() {
        return this.toList().toString();
    }

    private class JoinedDocumentIterator
    extends DocumentIterator {
        private Iterator<NitriteId> iterator;

        JoinedDocumentIterator(Resettable<Document> resettable) {
            super(resettable);
            this.iterator = JoinedDocumentIterable.this.resultSet.iterator();
            this.nextMatch();
        }

        @Override
        void nextMatch() {
            while (this.iterator.hasNext()) {
                NitriteId next = this.iterator.next();
                Document document = (Document)JoinedDocumentIterable.this.underlyingMap.get(next);
                Document joined = this.join(document, JoinedDocumentIterable.this.foreignCursor, JoinedDocumentIterable.this.lookup);
                if (joined == null) continue;
                this.nextElement = joined;
                return;
            }
            this.nextElement = null;
        }

        private Document join(Document localDocument, Cursor foreignCursor, Lookup lookup) {
            Object localObject = localDocument.get(lookup.getLocalField());
            if (localObject == null) {
                return localDocument;
            }
            Document resultDocument = new Document(localDocument);
            HashSet<Document> target = new HashSet<Document>();
            for (Document foreignDocument : foreignCursor) {
                Object foreignObject = foreignDocument.get(lookup.getForeignField());
                if (foreignObject == null || !EqualsUtils.deepEquals(foreignObject, localObject)) continue;
                target.add(foreignDocument);
            }
            if (!target.isEmpty()) {
                resultDocument.put(lookup.getTargetField(), (Object)target);
            }
            return resultDocument;
        }
    }
}

