/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.objects;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dizitart.no2.Document;
import org.dizitart.no2.RecordIterable;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.mapper.NitriteMapper;
import org.dizitart.no2.util.Iterables;

class JoinedObjectIterable<T>
implements RecordIterable<T> {
    private RecordIterable<Document> recordIterable;
    private Class<T> joinType;
    private JoinedObjectIterator iterator;
    private NitriteMapper nitriteMapper;

    JoinedObjectIterable(NitriteMapper nitriteMapper, RecordIterable<Document> recordIterable, Class<T> joinType) {
        this.recordIterable = recordIterable;
        this.joinType = joinType;
        this.nitriteMapper = nitriteMapper;
        this.iterator = new JoinedObjectIterator(nitriteMapper);
    }

    @Override
    public void reset() {
        this.recordIterable.reset();
        this.iterator = new JoinedObjectIterator(this.nitriteMapper);
    }

    @Override
    public boolean hasMore() {
        return this.recordIterable.hasMore();
    }

    @Override
    public int size() {
        return this.recordIterable.size();
    }

    @Override
    public int totalCount() {
        return this.recordIterable.totalCount();
    }

    @Override
    public T firstOrDefault() {
        Object item = Iterables.firstOrDefault(this);
        this.reset();
        return item;
    }

    @Override
    public List<T> toList() {
        List list = Iterables.toList(this);
        this.reset();
        return list;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator;
    }

    public String toString() {
        return this.toList().toString();
    }

    private class JoinedObjectIterator
    implements Iterator<T> {
        private NitriteMapper objectMapper;

        JoinedObjectIterator(NitriteMapper nitriteMapper) {
            this.objectMapper = nitriteMapper;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = true;
            try {
                boolean bl = hasNext = JoinedObjectIterable.this.recordIterable.iterator().hasNext();
                return bl;
            }
            finally {
                if (!hasNext) {
                    JoinedObjectIterable.this.reset();
                }
            }
        }

        @Override
        public T next() {
            Document record = new Document((Map)JoinedObjectIterable.this.recordIterable.iterator().next());
            record.remove("_id");
            return this.objectMapper.asObject(record, JoinedObjectIterable.this.joinType);
        }

        @Override
        public void remove() {
            throw new InvalidOperationException(ErrorMessage.OBJ_REMOVE_ON_JOINED_OBJECT_ITERATOR_NOT_SUPPORTED);
        }
    }
}

