/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.exceptions.InvalidIdException;
import org.dizitart.no2.exceptions.NotIdentifiableException;
import org.dizitart.no2.mapper.NitriteMapper;
import org.dizitart.no2.objects.Id;
import org.dizitart.no2.objects.Index;
import org.dizitart.no2.objects.Indices;
import org.dizitart.no2.objects.InheritIndices;
import org.dizitart.no2.objects.ObjectFilter;
import org.dizitart.no2.objects.filters.ObjectFilters;
import org.dizitart.no2.util.ReflectionUtils;
import org.dizitart.no2.util.StringUtils;
import org.dizitart.no2.util.ValidationUtils;
import org.objenesis.ObjenesisStd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectUtils {
    private static final Logger log = LoggerFactory.getLogger(ObjectUtils.class);

    public static <T> String findObjectStoreName(Class<T> type) {
        ValidationUtils.notNull(type, ErrorMessage.errorMessage("type can not be null", 1029));
        return type.getName();
    }

    public static <T> Set<Index> extractIndices(NitriteMapper nitriteMapper, Class<T> type) {
        ArrayList<Index> indexList;
        List<Object> indicesList;
        ValidationUtils.notNull(type, ErrorMessage.errorMessage("type can not be null", 1030));
        if (type.isAnnotationPresent(InheritIndices.class)) {
            indicesList = ReflectionUtils.getAnnotationUpto(Indices.class, type, Object.class);
        } else {
            indicesList = new ArrayList();
            Indices indices = type.getAnnotation(Indices.class);
            if (indices != null) {
                indicesList.add(indices);
            }
        }
        LinkedHashSet<Index> indexSet = new LinkedHashSet<Index>();
        if (indicesList != null) {
            for (Indices indices : indicesList) {
                Index[] indexList2 = indices.value();
                ObjectUtils.populateIndex(nitriteMapper, type, Arrays.asList(indexList2), indexSet);
            }
        }
        if (type.isAnnotationPresent(InheritIndices.class)) {
            indexList = ReflectionUtils.getAnnotationUpto(Index.class, type, Object.class);
        } else {
            indexList = new ArrayList();
            Index index = type.getAnnotation(Index.class);
            if (index != null) {
                indexList.add(index);
            }
        }
        if (indexList != null) {
            ObjectUtils.populateIndex(nitriteMapper, type, indexList, indexSet);
        }
        return indexSet;
    }

    public static <T> Field getIdField(NitriteMapper nitriteMapper, Class<T> type) {
        Field[] fields = type.isAnnotationPresent(InheritIndices.class) ? type.getFields() : type.getDeclaredFields();
        boolean alreadyIdFound = false;
        Field idField = null;
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Id.class)) continue;
            ValidationUtils.validateObjectIndexField(nitriteMapper, field.getType(), field.getName());
            if (alreadyIdFound) {
                throw new NotIdentifiableException(ErrorMessage.OBJ_MULTIPLE_ID_FOUND);
            }
            alreadyIdFound = true;
            idField = field;
        }
        return idField;
    }

    public static ObjectFilter createUniqueFilter(Object object, Field idField) {
        idField.setAccessible(true);
        try {
            Object value = idField.get(object);
            if (value == null) {
                throw new InvalidIdException(ErrorMessage.ID_FILTER_VALUE_CAN_NOT_BE_NULL);
            }
            return ObjectFilters.eq(idField.getName(), value);
        }
        catch (IllegalAccessException iae) {
            throw new InvalidIdException(ErrorMessage.ID_FIELD_IS_NOT_ACCESSIBLE);
        }
    }

    public static boolean isObjectStore(String collectionName) {
        try {
            if (StringUtils.isNullOrEmpty(collectionName)) {
                return false;
            }
            Class<?> clazz = Class.forName(collectionName);
            return clazz != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            return (T)new ObjenesisStd().newInstance(type);
        }
    }

    private static <T> void populateIndex(NitriteMapper nitriteMapper, Class<T> type, List<Index> indexList, Set<Index> indexSet) {
        for (Index index : indexList) {
            String name = index.value();
            Field field = ReflectionUtils.getField(type, name);
            if (field != null) {
                ValidationUtils.validateObjectIndexField(nitriteMapper, field.getType(), field.getName());
                indexSet.add(index);
                continue;
            }
            throw new IndexingException(ErrorMessage.errorMessage("field " + name + " does not exists for type " + type.getName(), 5013));
        }
    }

    private ObjectUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

