/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.ValidationException;
import org.dizitart.no2.objects.InheritIndices;
import org.dizitart.no2.util.DocumentUtils;
import org.dizitart.no2.util.StringUtils;
import org.dizitart.no2.util.ValidationUtils;

public final class ReflectionUtils {
    public static List<Field> getFieldsUpto(Class<?> startClass, Class<?> exclusiveParent) {
        ValidationUtils.notNull(startClass, ErrorMessage.errorMessage("startClass can not be null", 1027));
        ArrayList<Field> currentClassFields = new ArrayList<Field>(Arrays.asList(startClass.getDeclaredFields()));
        ReflectionUtils.filterSynthetics(currentClassFields);
        Class<?> parentClass = startClass.getSuperclass();
        if (!(parentClass == null || exclusiveParent != null && parentClass.equals(exclusiveParent))) {
            List<Field> parentClassFields = ReflectionUtils.getFieldsUpto(parentClass, exclusiveParent);
            currentClassFields.addAll(parentClassFields);
        }
        return currentClassFields;
    }

    static <T extends Annotation> List<T> getAnnotationUpto(Class<T> annotation, Class<?> startClass, Class<?> exclusiveParent) {
        Class<?> parentClass;
        ValidationUtils.notNull(startClass, ErrorMessage.errorMessage("startClass can not be null", 1025));
        ValidationUtils.notNull(annotation, ErrorMessage.errorMessage("annotationClass can not be null", 1026));
        ArrayList<T> annotations = new ArrayList<T>();
        T t = startClass.getAnnotation(annotation);
        if (t != null) {
            annotations.add(t);
        }
        if (!((parentClass = startClass.getSuperclass()) == null || exclusiveParent != null && parentClass.equals(exclusiveParent))) {
            List<T> list = ReflectionUtils.getAnnotationUpto(annotation, parentClass, exclusiveParent);
            annotations.addAll(list);
        }
        return annotations;
    }

    static List<Field> getAnnotatedFields(Class<?> startClass, Class<? extends Annotation> annotationClass) {
        ValidationUtils.notNull(startClass, ErrorMessage.errorMessage("startClass can not be null", 1025));
        ValidationUtils.notNull(annotationClass, ErrorMessage.errorMessage("annotationClass can not be null", 1026));
        List<Field> fields = ReflectionUtils.getFieldsUpto(startClass, Object.class);
        ArrayList<Field> filtered = new ArrayList<Field>();
        for (Field field : fields) {
            Annotation annotation = field.getAnnotation(annotationClass);
            if (annotation == null) continue;
            filtered.add(field);
        }
        return filtered;
    }

    static <T> Field getField(Class<T> type, String name) {
        if (name.contains(DocumentUtils.FIELD_SEPARATOR)) {
            return ReflectionUtils.getEmbeddedField(type, name);
        }
        try {
            if (type.isAnnotationPresent(InheritIndices.class)) {
                return type.getField(name);
            }
            return type.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            throw new ValidationException(ErrorMessage.errorMessage("no such value '" + name + "' for type " + type.getName(), 1028));
        }
    }

    private static void filterSynthetics(List<Field> fields) {
        if (fields == null || fields.isEmpty()) {
            return;
        }
        Iterator<Field> iterator = fields.iterator();
        while (iterator.hasNext()) {
            Field f = iterator.next();
            if (!f.isSynthetic()) continue;
            iterator.remove();
        }
    }

    private static <T> Field getEmbeddedField(Class<T> startingClass, String embeddedField) {
        Field field;
        String remaining;
        String regex = "\\" + DocumentUtils.FIELD_SEPARATOR;
        String[] split = embeddedField.split(regex, 2);
        String key = split[0];
        String string = remaining = split.length == 2 ? split[1] : "";
        if (StringUtils.isNullOrEmpty(key)) {
            throw new ValidationException(ErrorMessage.OBJ_INVALID_EMBEDDED_FIELD);
        }
        try {
            field = startingClass.getDeclaredField(key);
        }
        catch (NoSuchFieldException nsfe) {
            throw new ValidationException(ErrorMessage.errorMessage("no such value '" + key + "' for type " + startingClass.getName(), 1075));
        }
        if (!StringUtils.isNullOrEmpty(remaining) || remaining.contains(DocumentUtils.FIELD_SEPARATOR)) {
            return ReflectionUtils.getEmbeddedField(field.getType(), remaining);
        }
        return field;
    }

    private ReflectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

