/*
 *
 * Copyright 2017 Nitrite author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.dizitart.no2.fulltext.languages;

import org.dizitart.no2.fulltext.Language;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * Vietnamese stop words
 *
 * @since 2.1.0
 * @author Anindya Chatterjee
 */
public class Vietnamese implements Language {
    @Override
    public Set<String> stopWords() {
        return new HashSet<>(Arrays.asList(
                "a ha",
                "a-lô",
                "ai",
                "ai ai",
                "ai nấy",
                "alô",
                "amen",
                "anh",
                "bao giờ",
                "bao lâu",
                "bao nhiêu",
                "bao nả",
                "bay biến",
                "biết",
                "biết bao",
                "biết bao nhiêu",
                "biết chừng nào",
                "biết mấy",
                "biết đâu",
                "biết đâu chừng",
                "biết đâu đấy",
                "bà",
                "bài",
                "bác",
                "bây bẩy",
                "bây chừ",
                "bây giờ",
                "bây nhiêu",
                "bèn",
                "béng",
                "bông",
                "bạn",
                "bản",
                "bất chợt",
                "bất cứ",
                "bất giác",
                "bất kì",
                "bất kể",
                "bất kỳ",
                "bất luận",
                "bất nhược",
                "bất quá",
                "bất thình lình",
                "bất tử",
                "bất đồ",
                "bấy",
                "bấy chầy",
                "bấy chừ",
                "bấy giờ",
                "bấy lâu",
                "bấy lâu nay",
                "bấy nay",
                "bấy nhiêu",
                "bập bà bập bõm",
                "bập bõm",
                "bắt đầu từ",
                "bằng",
                "bằng không",
                "bằng nấy",
                "bằng ấy",
                "bển",
                "bệt",
                "bị",
                "bỏ mẹ",
                "bỗng",
                "bỗng chốc",
                "bỗng dưng",
                "bỗng không",
                "bỗng nhiên",
                "bỗng đâu",
                "bộ",
                "bội phần",
                "bớ",
                "bởi",
                "bởi chưng",
                "bởi nhưng",
                "bởi thế",
                "bởi vì",
                "bởi vậy",
                "bức",
                "cao",
                "cha",
                "cha chả",
                "chao ôi",
                "chiếc",
                "cho",
                "cho nên",
                "cho tới",
                "cho tới khi",
                "cho đến",
                "cho đến khi",
                "choa",
                "chu cha",
                "chui cha",
                "chung cục",
                "chung qui",
                "chung quy",
                "chung quy lại",
                "chuyện",
                "chành chạnh",
                "chí chết",
                "chính",
                "chính là",
                "chính thị",
                "chùn chùn",
                "chùn chũn",
                "chú",
                "chú mày",
                "chú mình",
                "chúng mình",
                "chúng ta",
                "chúng tôi",
                "chăn chắn",
                "chăng",
                "chưa",
                "chầm chập",
                "chậc",
                "chắc",
                "chắc hẳn",
                "chẳng lẽ",
                "chẳng những",
                "chẳng nữa",
                "chẳng phải",
                "chết nỗi",
                "chết thật",
                "chết tiệt",
                "chỉ",
                "chỉn",
                "chốc chốc",
                "chớ",
                "chớ chi",
                "chợt",
                "chủn",
                "chứ",
                "chứ lị",
                "coi bộ",
                "coi mòi",
                "con",
                "cu cậu",
                "cuốn",
                "cuộc",
                "càng",
                "các",
                "cái",
                "cây",
                "còn",
                "có",
                "có chăng là",
                "có dễ",
                "có thể",
                "có vẻ",
                "cóc khô",
                "cô",
                "cô mình",
                "công nhiên",
                "cùng",
                "cùng cực",
                "cùng nhau",
                "cùng với",
                "căn",
                "căn cắt",
                "cũng",
                "cũng như",
                "cũng vậy",
                "cũng vậy thôi",
                "cơ",
                "cơ chừng",
                "cơ hồ",
                "cơ mà",
                "cơn",
                "cả",
                "cả thảy",
                "cả thể",
                "cảm ơn",
                "cần",
                "cật lực",
                "cật sức",
                "cậu",
                "cổ lai",
                "của",
                "cứ",
                "cứ việc",
                "cực lực",
                "do",
                "do vì",
                "do vậy",
                "do đó",
                "duy",
                "dào",
                "dì",
                "dù cho",
                "dù rằng",
                "dưới",
                "dạ",
                "dần dà",
                "dần dần",
                "dầu sao",
                "dẫu",
                "dẫu sao",
                "dễ sợ",
                "dễ thường",
                "dở chừng",
                "dữ",
                "em",
                "giữa",
                "gì",
                "hay",
                "hoàn toàn",
                "hoặc",
                "hơn",
                "hầu hết",
                "họ",
                "hỏi",
                "khi",
                "khác",
                "không",
                "luôn",
                "là",
                "làm",
                "lên",
                "lúc",
                "lại",
                "lần",
                "lớn",
                "muốn",
                "mà",
                "mình",
                "mỗi",
                "một",
                "một cách",
                "mới",
                "mợ",
                "ngay",
                "ngay cả",
                "ngay khi",
                "ngay lúc",
                "ngay lập tức",
                "ngay tức khắc",
                "ngay từ",
                "nghe chừng",
                "nghe đâu",
                "nghen",
                "nghiễm nhiên",
                "nghỉm",
                "ngoài",
                "ngoài ra",
                "ngoải",
                "ngày",
                "ngày càng",
                "ngày ngày",
                "ngày xưa",
                "ngày xửa",
                "ngôi",
                "ngõ hầu",
                "ngăn ngắt",
                "ngươi",
                "người",
                "ngọn",
                "ngọt",
                "ngộ nhỡ",
                "nh",
                "nhau",
                "nhiên hậu",
                "nhiều",
                "nhiệt liệt",
                "nhung nhăng",
                "nhà",
                "nhân dịp",
                "nhân tiện",
                "nhé",
                "nhón nhén",
                "như",
                "như chơi",
                "như không",
                "như quả",
                "như thể",
                "như tuồng",
                "như vậy",
                "nhưng",
                "nhưng mà",
                "nhược bằng",
                "nhất",
                "nhất loạt",
                "nhất luật",
                "nhất mực",
                "nhất nhất",
                "nhất quyết",
                "nhất sinh",
                "nhất thiết",
                "nhất tâm",
                "nhất tề",
                "nhất đán",
                "nhất định",
                "nhận",
                "nhỉ",
                "nhỡ ra",
                "những",
                "những ai",
                "những như",
                "nào",
                "này",
                "nên",
                "nên chi",
                "nó",
                "nóc",
                "nói",
                "năm",
                "nơi",
                "nấy",
                "nếu",
                "nếu như",
                "nền",
                "nọ",
                "nớ",
                "nức nở",
                "nữa",
                "oai oái",
                "oái",
                "pho",
                "phè",
                "phóc",
                "phót",
                "phăn phắt",
                "phương chi",
                "phải",
                "phải chi",
                "phải chăng",
                "phắt",
                "phỉ phui",
                "phỏng",
                "phỏng như",
                "phốc",
                "phụt",
                "phứt",
                "qua",
                "qua quít",
                "qua quýt",
                "quyết",
                "quyết nhiên",
                "quyển",
                "quá",
                "quá chừng",
                "quá lắm",
                "quá sá",
                "quá thể",
                "quá trời",
                "quá xá",
                "quá đỗi",
                "quá độ",
                "quá ư",
                "quý hồ",
                "quả",
                "quả là",
                "quả tang",
                "quả thật",
                "quả tình",
                "quả vậy",
                "quả đúng",
                "ra",
                "ra phết",
                "ra sao",
                "ra trò",
                "ren rén",
                "riu ríu",
                "riêng",
                "riệt",
                "rày",
                "ráo",
                "ráo trọi",
                "rén",
                "rích",
                "rón rén",
                "rút cục",
                "răng",
                "rất",
                "rằng",
                "rằng là",
                "rốt cuộc",
                "rốt cục",
                "rồi",
                "rứa",
                "sa sả",
                "sao",
                "sau",
                "sau chót",
                "sau cuối",
                "sau cùng",
                "sau đó",
                "so",
                "song le",
                "suýt",
                "sì",
                "sạch",
                "sất",
                "sắp",
                "sẽ",
                "số",
                "số là",
                "sốt sột",
                "sở dĩ",
                "sự",
                "tanh",
                "tha hồ",
                "than ôi",
                "thanh",
                "theo",
                "thi thoảng",
                "thoạt",
                "thoạt nhiên",
                "thoắt",
                "thuần",
                "thà",
                "thà là",
                "thà rằng",
                "thành ra",
                "thành thử",
                "thái quá",
                "tháng",
                "thì",
                "thì thôi",
                "thình lình",
                "thím",
                "thôi",
                "thúng thắng",
                "thương ôi",
                "thường",
                "thảo hèn",
                "thảo nào",
                "thấy",
                "thẩy",
                "thậm",
                "thậm chí",
                "thật lực",
                "thật ra",
                "thật vậy",
                "thế",
                "thế là",
                "thế mà",
                "thế nào",
                "thế nên",
                "thế ra",
                "thế thì",
                "thế à",
                "thếch",
                "thỉnh thoảng",
                "thỏm",
                "thốc",
                "thốc tháo",
                "thốt",
                "thốt nhiên",
                "thộc",
                "thời gian",
                "thục mạng",
                "thửa",
                "thực ra",
                "thực sự",
                "thực vậy",
                "tiếp theo",
                "tiếp đó",
                "tiện thể",
                "toà",
                "toé khói",
                "toẹt",
                "trong",
                "trên",
                "trước",
                "trước kia",
                "trước nay",
                "trước tiên",
                "trước đây",
                "trước đó",
                "trếu tráo",
                "trển",
                "trệt",
                "trệu trạo",
                "trỏng",
                "trời đất ơi",
                "trừ phi",
                "tuy",
                "tuy nhiên",
                "tuy rằng",
                "tuy thế",
                "tuy vậy",
                "tuyệt nhiên",
                "tuần tự",
                "tuốt luốt",
                "tuốt tuồn tuột",
                "tuốt tuột",
                "tà tà",
                "tênh",
                "tít mù",
                "tò te",
                "tôi",
                "tông tốc",
                "tù tì",
                "tăm tắp",
                "tại",
                "tại vì",
                "tấm",
                "tấn",
                "tất cả",
                "tất thảy",
                "tất tần tật",
                "tất tật",
                "tắp",
                "tắp lự",
                "tọt",
                "tỏ ra",
                "tỏ vẻ",
                "tốc tả",
                "tối ư",
                "tột",
                "tớ",
                "tới",
                "tức thì",
                "tức tốc",
                "từ",
                "từng",
                "tự vì",
                "tựu trung",
                "veo",
                "veo veo",
                "việc",
                "vung thiên địa",
                "vung tàn tán",
                "vung tán tàn",
                "và",
                "vào",
                "vâng",
                "vèo",
                "vì",
                "vì chưng",
                "vì thế",
                "vì vậy",
                "ví bằng",
                "ví dù",
                "ví phỏng",
                "ví thử",
                "vô hình trung",
                "vô kể",
                "vô luận",
                "vô vàn",
                "văng tê",
                "vạn nhất",
                "vả chăng",
                "vả lại",
                "vẫn",
                "vậy",
                "vậy là",
                "vậy thì",
                "về",
                "vị tất",
                "vốn dĩ",
                "với",
                "với lại",
                "vở",
                "vụt",
                "vừa",
                "vừa mới",
                "xa xả",
                "xiết bao",
                "xon xón",
                "xoành xoạch",
                "xoét",
                "xoẳn",
                "xoẹt",
                "xuất kì bất ý",
                "xuất kỳ bất ý",
                "xuể",
                "xuống",
                "xăm xúi",
                "xăm xăm",
                "xăm xắm",
                "xềnh xệch",
                "xệp",
                "à",
                "à ơi",
                "ào",
                "á",
                "á à",
                "ái",
                "ái chà",
                "ái dà",
                "áng",
                "âu là",
                "ô hay",
                "ô hô",
                "ô kê",
                "ô kìa",
                "ôi chao",
                "ôi thôi",
                "ông",
                "úi",
                "úi chà",
                "úi dào",
                "ý",
                "ý chừng",
                "ý da",
                "đang",
                "đi",
                "điều",
                "đành đạch",
                "đáng lí",
                "đáng lý",
                "đáng lẽ",
                "đánh đùng",
                "đáo để",
                "đây",
                "đã",
                "đó",
                "được",
                "đại loại",
                "đại nhân",
                "đại phàm",
                "đại để",
                "đến",
                "đến nỗi",
                "đều",
                "để",
                "ơ",
                "ơ hay",
                "ơ kìa",
                "ơi",
                "ư",
                "ạ",
                "ạ ơi",
                "ấy",
                "ầu ơ",
                "ắt",
                "ắt hẳn",
                "ắt là",
                "ối dào",
                "ối giời",
                "ối giời ơi",
                "ồ",
                "ổng",
                "ớ",
                "ờ",
                "ở",
                "ở trên",
                "ủa",
                "ứ hự",
                "ứ ừ",
                "ừ",
                "ử"
        ));
    }
}
