/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.objects;

import java.util.Iterator;
import java.util.List;
import org.dizitart.no2.Document;
import org.dizitart.no2.RecordIterable;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.mapper.NitriteMapper;
import org.dizitart.no2.util.Iterables;

class JoinedObjectIterable<T>
implements RecordIterable<T> {
    private RecordIterable<Document> recordIterable;
    private Class<T> joinType;
    private NitriteMapper nitriteMapper;

    JoinedObjectIterable(NitriteMapper nitriteMapper, RecordIterable<Document> recordIterable, Class<T> joinType) {
        this.recordIterable = recordIterable;
        this.joinType = joinType;
        this.nitriteMapper = nitriteMapper;
    }

    @Override
    public boolean hasMore() {
        return this.recordIterable.hasMore();
    }

    @Override
    public int size() {
        return this.recordIterable.size();
    }

    @Override
    public int totalCount() {
        return this.recordIterable.totalCount();
    }

    @Override
    public T firstOrDefault() {
        return Iterables.firstOrDefault(this);
    }

    @Override
    public List<T> toList() {
        return Iterables.toList(this);
    }

    @Override
    public Iterator<T> iterator() {
        return new JoinedObjectIterator(this.nitriteMapper);
    }

    public String toString() {
        return this.toList().toString();
    }

    private class JoinedObjectIterator
    implements Iterator<T> {
        private NitriteMapper objectMapper;
        private Iterator<Document> documentIterator;

        JoinedObjectIterator(NitriteMapper nitriteMapper) {
            this.objectMapper = nitriteMapper;
            this.documentIterator = JoinedObjectIterable.this.recordIterable.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.documentIterator.hasNext();
        }

        @Override
        public T next() {
            Document record = new Document(this.documentIterator.next());
            record.remove("_id");
            return this.objectMapper.asObject(record, JoinedObjectIterable.this.joinType);
        }

        @Override
        public void remove() {
            throw new InvalidOperationException(ErrorMessage.OBJ_REMOVE_ON_JOINED_OBJECT_ITERATOR_NOT_SUPPORTED);
        }
    }
}

