/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.internals;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dizitart.no2.Document;
import org.dizitart.no2.Index;
import org.dizitart.no2.IndexType;
import org.dizitart.no2.NitriteContext;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.exceptions.UniqueConstraintException;
import org.dizitart.no2.fulltext.TextIndexingService;
import org.dizitart.no2.internals.IndexMetaService;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.DocumentUtils;
import org.dizitart.no2.util.ValidationUtils;

class IndexingService {
    private final NitriteMap<NitriteId, Document> underlyingMap;
    private final IndexMetaService indexMetaService;
    private final Map<String, AtomicBoolean> indexBuildRegistry;
    private final ExecutorService rebuildExecutor;
    private final TextIndexingService textIndexingService;
    private final Object indexLock = new Object();

    IndexingService(IndexMetaService indexMetaService, TextIndexingService textIndexingService, NitriteContext nitriteContext) {
        this.indexBuildRegistry = new ConcurrentHashMap<String, AtomicBoolean>();
        this.rebuildExecutor = nitriteContext.getWorkerPool();
        this.indexMetaService = indexMetaService;
        this.textIndexingService = textIndexingService;
        this.underlyingMap = indexMetaService.getUnderlyingMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createIndex(String field, IndexType indexType, boolean isAsync) {
        Index index;
        Object object = this.indexLock;
        synchronized (object) {
            if (this.indexMetaService.hasIndex(field)) {
                throw new IndexingException(ErrorMessage.errorMessage("index already exists on " + field, 5005));
            }
            index = this.indexMetaService.createIndexMetadata(field, indexType);
        }
        try {
            this.rebuildIndex(index, isAsync);
        }
        catch (IllegalStateException ise) {
            throw new IndexingException(ErrorMessage.errorMessage(ise.getMessage(), 5006), (Throwable)ise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateIndexEntry(Document document, NitriteId nitriteId) {
        Set<String> fields = DocumentUtils.getFields(document);
        for (String field : fields) {
            Object fieldValue;
            Index index = this.indexMetaService.findIndex(field);
            if (index == null || (fieldValue = DocumentUtils.getFieldValue(document, field)) == null) continue;
            ValidationUtils.validateDocumentIndexField(fieldValue, field);
            if (this.indexMetaService.isDirtyIndex(field) && this.indexBuildRegistry.get(field) != null && !this.indexBuildRegistry.get(field).get()) {
                this.rebuildIndex(index, true);
                continue;
            }
            IndexType indexType = index.getIndexType();
            if (indexType == IndexType.Fulltext && fieldValue instanceof String) {
                this.textIndexingService.updateIndex(nitriteId, field, (String)fieldValue);
                continue;
            }
            Object object = this.indexLock;
            synchronized (object) {
                NitriteMap<Comparable, ConcurrentSkipListSet<NitriteId>> indexMap = this.indexMetaService.getIndexMap(field);
                ConcurrentSkipListSet<NitriteId> nitriteIdList = indexMap.get((Comparable)fieldValue);
                if (nitriteIdList == null) {
                    nitriteIdList = new ConcurrentSkipListSet();
                }
                if (indexType == IndexType.Unique && nitriteIdList.size() == 1 && !nitriteIdList.contains(nitriteId)) {
                    throw new UniqueConstraintException(ErrorMessage.errorMessage("unique key constraint violation for " + field, 10003));
                }
                nitriteIdList.add(nitriteId);
                indexMap.put((Comparable)fieldValue, nitriteIdList);
            }
        }
    }

    void removeIndexEntry(Document document, NitriteId nitriteId) {
        Set<String> fields = DocumentUtils.getFields(document);
        for (String field : fields) {
            ConcurrentSkipListSet<NitriteId> nitriteIdList;
            Object fieldValue;
            Index index = this.indexMetaService.findIndex(field);
            if (index == null || (fieldValue = DocumentUtils.getFieldValue(document, field)) == null) continue;
            if (this.indexMetaService.isDirtyIndex(field) && !this.indexBuildRegistry.get(field).get()) {
                this.rebuildIndex(index, true);
                continue;
            }
            IndexType indexType = index.getIndexType();
            if (indexType == IndexType.Fulltext && fieldValue instanceof String) {
                this.textIndexingService.deleteIndex(nitriteId, field, (String)fieldValue);
                continue;
            }
            NitriteMap<Comparable, ConcurrentSkipListSet<NitriteId>> indexMap = this.indexMetaService.getIndexMap(field);
            if (!(fieldValue instanceof Comparable) || (nitriteIdList = indexMap.get((Comparable)fieldValue)) == null) continue;
            nitriteIdList.remove(nitriteId);
            if (nitriteIdList.size() == 0) {
                indexMap.remove((Comparable)fieldValue);
                continue;
            }
            indexMap.put((Comparable)fieldValue, nitriteIdList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshIndexEntry(Document oldDocument, Document newDocument, NitriteId nitriteId) {
        Set<String> fields = DocumentUtils.getFields(newDocument);
        for (String field : fields) {
            Index index = this.indexMetaService.findIndex(field);
            if (index == null) continue;
            Object newValue = DocumentUtils.getFieldValue(newDocument, field);
            Object oldValue = DocumentUtils.getFieldValue(oldDocument, field);
            if (newValue == null || newValue instanceof Comparable && oldValue instanceof Comparable && ((Comparable)newValue).compareTo(oldValue) == 0) continue;
            ValidationUtils.validateDocumentIndexField(newValue, field);
            if (this.indexMetaService.isDirtyIndex(field) && this.indexBuildRegistry.get(field) != null && !this.indexBuildRegistry.get(field).get()) {
                this.rebuildIndex(index, true);
                continue;
            }
            IndexType indexType = index.getIndexType();
            if (indexType == IndexType.Fulltext && newValue instanceof String) {
                this.textIndexingService.updateIndex(nitriteId, field, (String)newValue);
                continue;
            }
            Object object = this.indexLock;
            synchronized (object) {
                NitriteMap<Comparable, ConcurrentSkipListSet<NitriteId>> indexMap = this.indexMetaService.getIndexMap(field);
                ConcurrentSkipListSet<NitriteId> nitriteIdList = indexMap.get((Comparable)newValue);
                if (nitriteIdList == null) {
                    nitriteIdList = new ConcurrentSkipListSet();
                }
                if (indexType == IndexType.Unique && nitriteIdList.size() == 1 && !nitriteIdList.contains(nitriteId)) {
                    throw new UniqueConstraintException(ErrorMessage.errorMessage("unique key constraint violation for " + field, 10004));
                }
                nitriteIdList.add(nitriteId);
                indexMap.put((Comparable)newValue, nitriteIdList);
                nitriteIdList = indexMap.get((Comparable)oldValue);
                if (nitriteIdList != null && !nitriteIdList.isEmpty()) {
                    nitriteIdList.remove(nitriteId);
                    if (nitriteIdList.size() == 0) {
                        indexMap.remove((Comparable)oldValue);
                    } else {
                        indexMap.put((Comparable)oldValue, nitriteIdList);
                    }
                }
            }
        }
    }

    Collection<Index> listIndexes() {
        return this.indexMetaService.listIndexes();
    }

    boolean isIndexing(String field) {
        return this.indexMetaService.hasIndex(field) && this.indexBuildRegistry.get(field) != null && this.indexBuildRegistry.get(field).get();
    }

    void dropIndex(String field) {
        if (this.indexBuildRegistry.get(field) != null && this.indexBuildRegistry.get(field).get()) {
            throw new IndexingException(ErrorMessage.errorMessage("can not drop index as indexing is running on " + field, 5008));
        }
        if (this.indexMetaService.hasTextIndex(field)) {
            this.textIndexingService.deleteIndexesByField(field);
        } else {
            this.indexMetaService.dropIndex(field);
        }
        this.indexBuildRegistry.remove(field);
    }

    void dropAllIndices() {
        for (Map.Entry<String, AtomicBoolean> entry : this.indexBuildRegistry.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().get()) continue;
            throw new IndexingException(ErrorMessage.errorMessage("can not drop index as indexing is running on " + entry.getKey(), 5007));
        }
        this.indexMetaService.dropAll();
        this.textIndexingService.drop();
        this.indexBuildRegistry.clear();
    }

    void rebuildIndex(final Index index, boolean isAsync) {
        final String field = index.getField();
        if (this.getBuildFlag(field).compareAndSet(false, true)) {
            if (isAsync) {
                this.rebuildExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        IndexingService.this.buildIndexInternal(field, index);
                    }
                });
            } else {
                this.buildIndexInternal(field, index);
            }
            return;
        }
        throw new IndexingException(ErrorMessage.errorMessage("indexing is already running on " + index.getField(), 5009));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildIndexInternal(String field, Index index) {
        try {
            this.indexMetaService.markDirty(field);
            if (index.getIndexType() != IndexType.Fulltext) {
                NitriteMap<Comparable, ConcurrentSkipListSet<NitriteId>> indexMap = this.indexMetaService.getIndexMap(field);
                indexMap.clear();
                for (Map.Entry<NitriteId, Document> entry : this.underlyingMap.entrySet()) {
                    Document object = entry.getValue();
                    Object fieldValue = DocumentUtils.getFieldValue(object, field);
                    if (fieldValue == null) continue;
                    ValidationUtils.validateDocumentIndexField(fieldValue, field);
                    ConcurrentSkipListSet<NitriteId> nitriteIdList = indexMap.get((Comparable)fieldValue);
                    if (nitriteIdList == null) {
                        nitriteIdList = new ConcurrentSkipListSet();
                    }
                    if (index.getIndexType() == IndexType.Unique && nitriteIdList.size() == 1) {
                        throw new UniqueConstraintException(ErrorMessage.errorMessage("unique key constraint violation for " + field, 10002));
                    }
                    nitriteIdList.add(entry.getKey());
                    indexMap.put((Comparable)fieldValue, nitriteIdList);
                }
            } else {
                for (Map.Entry<NitriteId, Document> entry : this.underlyingMap.entrySet()) {
                    Document object = entry.getValue();
                    Object fieldValue = DocumentUtils.getFieldValue(object, field);
                    if (fieldValue == null) continue;
                    if (!(fieldValue instanceof String)) {
                        throw new IndexingException(ErrorMessage.NON_STRING_VALUE_IN_FULL_TEXT_INDEX);
                    }
                    this.textIndexingService.createIndex(entry.getKey(), field, (String)fieldValue);
                }
            }
        }
        finally {
            this.indexMetaService.unmarkDirty(field);
            this.getBuildFlag(field).set(false);
        }
    }

    private synchronized AtomicBoolean getBuildFlag(String field) {
        AtomicBoolean flag = this.indexBuildRegistry.get(field);
        if (flag != null) {
            return flag;
        }
        flag = new AtomicBoolean(false);
        this.indexBuildRegistry.put(field, flag);
        return flag;
    }
}

