/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mapper;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dizitart.no2.Document;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.ObjectMappingException;
import org.dizitart.no2.mapper.AbstractMapper;
import org.dizitart.no2.mapper.NitriteIdModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonMapper
extends AbstractMapper {
    private static final Logger log = LoggerFactory.getLogger(JacksonMapper.class);
    private ObjectMapper objectMapper;

    public JacksonMapper() {
        this.getObjectMapper();
    }

    @Override
    public <T> Document asDocumentInternal(T object) {
        ObjectMapper objectMapper = this.getObjectMapper();
        try {
            JsonNode node = (JsonNode)objectMapper.convertValue(object, JsonNode.class);
            return this.loadDocument(node);
        }
        catch (IllegalArgumentException iae) {
            JsonMappingException jme;
            log.error("Error while converting object to document ", (Throwable)iae);
            if (iae.getCause() instanceof JsonMappingException && (jme = (JsonMappingException)iae.getCause()).getCause() instanceof StackOverflowError) {
                throw new ObjectMappingException(ErrorMessage.errorMessage("cyclic reference detected. " + jme.getPathReference(), 9001));
            }
            throw iae;
        }
    }

    @Override
    public <T> T asObjectInternal(Document document, Class<T> type) {
        try {
            return (T)this.getObjectMapper().convertValue((Object)document, type);
        }
        catch (IllegalArgumentException iae) {
            JsonMappingException jme;
            log.error("Error while converting document to object ", (Throwable)iae);
            if (iae.getCause() instanceof JsonMappingException && (jme = (JsonMappingException)iae.getCause()).getMessage().contains("Cannot construct instance")) {
                throw new ObjectMappingException(ErrorMessage.errorMessage(jme.getMessage(), 9002));
            }
            throw iae;
        }
    }

    @Override
    public boolean isValueType(Object object) {
        ObjectMapper objectMapper = this.getObjectMapper();
        JsonNode node = (JsonNode)objectMapper.convertValue(object, JsonNode.class);
        return node != null && node.isValueNode();
    }

    @Override
    public Object asValue(Object object) {
        ObjectMapper objectMapper = this.getObjectMapper();
        JsonNode node = (JsonNode)objectMapper.convertValue(object, JsonNode.class);
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case NUMBER: {
                return node.numberValue();
            }
            case STRING: {
                return node.textValue();
            }
            case BOOLEAN: {
                return node.booleanValue();
            }
        }
        return null;
    }

    @Override
    public Document parse(String json) {
        ObjectMapper objectMapper = this.getObjectMapper();
        try {
            JsonNode node = (JsonNode)objectMapper.readValue(json, JsonNode.class);
            return this.loadDocument(node);
        }
        catch (IOException e) {
            log.error("Error while parsing json", (Throwable)e);
            throw new ObjectMappingException(ErrorMessage.errorMessage("failed to parse json " + json, 9003));
        }
    }

    @Override
    public String toJson(Object object) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.getObjectMapper().writeValue((Writer)stringWriter, object);
            return stringWriter.toString();
        }
        catch (IOException e) {
            log.error("Error while serializing object to json", (Throwable)e);
            throw new ObjectMappingException(ErrorMessage.JSON_SERIALIZATION_FAILED);
        }
    }

    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
            this.objectMapper.setVisibility(this.objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE));
            this.objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            this.objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            this.objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.objectMapper.registerModule((Module)new NitriteIdModule());
        }
        return this.objectMapper;
    }

    private Document loadDocument(JsonNode node) {
        LinkedHashMap<String, Object> objectMap = new LinkedHashMap<String, Object>();
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String name = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            Object object = this.loadObject(value);
            objectMap.put(name, object);
        }
        return new Document((Map<String, Object>)objectMap);
    }

    private Object loadObject(JsonNode node) {
        if (node == null) {
            return null;
        }
        try {
            switch (node.getNodeType()) {
                case ARRAY: {
                    return this.loadArray(node);
                }
                case BINARY: {
                    return node.binaryValue();
                }
                case BOOLEAN: {
                    return node.booleanValue();
                }
                case MISSING: 
                case NULL: {
                    return null;
                }
                case NUMBER: {
                    return node.numberValue();
                }
                case OBJECT: {
                    return this.loadDocument(node);
                }
                case POJO: {
                    return this.loadDocument(node);
                }
                case STRING: {
                    return node.textValue();
                }
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    private List loadArray(JsonNode array) {
        if (array.isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            Iterator iterator = array.elements();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (element instanceof JsonNode) {
                    list.add(this.loadObject((JsonNode)element));
                    continue;
                }
                list.add(element);
            }
            return list;
        }
        return null;
    }
}

