/*
 *
 * Copyright 2017 Nitrite author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.dizitart.no2.fulltext.languages;

import org.dizitart.no2.fulltext.Language;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * Dutch stop words
 *
 * @since 2.1.0
 * @author Anindya Chatterjee
 */
public class Dutch implements Language {
    @Override
    public Set<String> stopWords() {
        return new HashSet<>(Arrays.asList(
                "aan",
                "aangaande",
                "aangezien",
                "achte",
                "achter",
                "achterna",
                "af",
                "afgelopen",
                "al",
                "aldaar",
                "aldus",
                "alhoewel",
                "alias",
                "alle",
                "allebei",
                "alleen",
                "alles",
                "als",
                "alsnog",
                "altijd",
                "altoos",
                "ander",
                "andere",
                "anders",
                "anderszins",
                "beetje",
                "behalve",
                "behoudens",
                "beide",
                "beiden",
                "ben",
                "beneden",
                "bent",
                "bepaald",
                "betreffende",
                "bij",
                "bijna",
                "bijv",
                "binnen",
                "binnenin",
                "blijkbaar",
                "blijken",
                "boven",
                "bovenal",
                "bovendien",
                "bovengenoemd",
                "bovenstaand",
                "bovenvermeld",
                "buiten",
                "bv",
                "daar",
                "daardoor",
                "daarheen",
                "daarin",
                "daarna",
                "daarnet",
                "daarom",
                "daarop",
                "daaruit",
                "daarvanlangs",
                "dan",
                "dat",
                "de",
                "deden",
                "deed",
                "der",
                "derde",
                "derhalve",
                "dertig",
                "deze",
                "dhr",
                "die",
                "dikwijls",
                "dit",
                "doch",
                "doe",
                "doen",
                "doet",
                "door",
                "doorgaand",
                "drie",
                "duizend",
                "dus",
                "echter",
                "een",
                "eens",
                "eer",
                "eerdat",
                "eerder",
                "eerlang",
                "eerst",
                "eerste",
                "eigen",
                "eigenlijk",
                "elk",
                "elke",
                "en",
                "enig",
                "enige",
                "enigszins",
                "enkel",
                "er",
                "erdoor",
                "erg",
                "ergens",
                "etc",
                "etcetera",
                "even",
                "eveneens",
                "evenwel",
                "gauw",
                "ge",
                "gedurende",
                "geen",
                "gehad",
                "gekund",
                "geleden",
                "gelijk",
                "gemoeten",
                "gemogen",
                "genoeg",
                "geweest",
                "gewoon",
                "gewoonweg",
                "haar",
                "haarzelf",
                "had",
                "hadden",
                "hare",
                "heb",
                "hebben",
                "hebt",
                "hedden",
                "heeft",
                "heel",
                "hem",
                "hemzelf",
                "hen",
                "het",
                "hetzelfde",
                "hier",
                "hierbeneden",
                "hierboven",
                "hierin",
                "hierna",
                "hierom",
                "hij",
                "hijzelf",
                "hoe",
                "hoewel",
                "honderd",
                "hun",
                "hunne",
                "ieder",
                "iedere",
                "iedereen",
                "iemand",
                "iets",
                "ik",
                "ikzelf",
                "in",
                "inderdaad",
                "inmiddels",
                "intussen",
                "inzake",
                "is",
                "ja",
                "je",
                "jezelf",
                "jij",
                "jijzelf",
                "jou",
                "jouw",
                "jouwe",
                "juist",
                "jullie",
                "kan",
                "klaar",
                "kon",
                "konden",
                "krachtens",
                "kun",
                "kunnen",
                "kunt",
                "laatst",
                "later",
                "liever",
                "lijken",
                "lijkt",
                "maak",
                "maakt",
                "maakte",
                "maakten",
                "maar",
                "mag",
                "maken",
                "me",
                "meer",
                "meest",
                "meestal",
                "men",
                "met",
                "mevr",
                "mezelf",
                "mij",
                "mijn",
                "mijnent",
                "mijner",
                "mijzelf",
                "minder",
                "miss",
                "misschien",
                "missen",
                "mits",
                "mocht",
                "mochten",
                "moest",
                "moesten",
                "moet",
                "moeten",
                "mogen",
                "mr",
                "mrs",
                "mw",
                "na",
                "naar",
                "nadat",
                "nam",
                "namelijk",
                "nee",
                "neem",
                "negen",
                "nemen",
                "nergens",
                "net",
                "niemand",
                "niet",
                "niets",
                "niks",
                "noch",
                "nochtans",
                "nog",
                "nogal",
                "nooit",
                "nu",
                "nv",
                "of",
                "ofschoon",
                "om",
                "omdat",
                "omhoog",
                "omlaag",
                "omstreeks",
                "omtrent",
                "omver",
                "ondanks",
                "onder",
                "ondertussen",
                "ongeveer",
                "ons",
                "onszelf",
                "onze",
                "onzeker",
                "ooit",
                "ook",
                "op",
                "opnieuw",
                "opzij",
                "over",
                "overal",
                "overeind",
                "overige",
                "overigens",
                "paar",
                "pas",
                "per",
                "precies",
                "recent",
                "redelijk",
                "reeds",
                "rond",
                "rondom",
                "samen",
                "sedert",
                "sinds",
                "sindsdien",
                "slechts",
                "sommige",
                "spoedig",
                "steeds",
                "tamelijk",
                "te",
                "tegen",
                "tegenover",
                "tenzij",
                "terwijl",
                "thans",
                "tien",
                "tiende",
                "tijdens",
                "tja",
                "toch",
                "toe",
                "toen",
                "toenmaals",
                "toenmalig",
                "tot",
                "totdat",
                "tussen",
                "twee",
                "tweede",
                "u",
                "uit",
                "uitgezonderd",
                "uw",
                "vaak",
                "vaakwat",
                "van",
                "vanaf",
                "vandaan",
                "vanuit",
                "vanwege",
                "veel",
                "veeleer",
                "veertig",
                "verder",
                "verscheidene",
                "verschillende",
                "vervolgens",
                "via",
                "vier",
                "vierde",
                "vijf",
                "vijfde",
                "vijftig",
                "vol",
                "volgend",
                "volgens",
                "voor",
                "vooraf",
                "vooral",
                "vooralsnog",
                "voorbij",
                "voordat",
                "voordezen",
                "voordien",
                "voorheen",
                "voorop",
                "voorts",
                "vooruit",
                "vrij",
                "vroeg",
                "waar",
                "waarom",
                "waarschijnlijk",
                "wanneer",
                "want",
                "waren",
                "was",
                "wat",
                "we",
                "wederom",
                "weer",
                "weg",
                "wegens",
                "weinig",
                "wel",
                "weldra",
                "welk",
                "welke",
                "werd",
                "werden",
                "werder",
                "wezen",
                "whatever",
                "wie",
                "wiens",
                "wier",
                "wij",
                "wijzelf",
                "wil",
                "wilden",
                "willen",
                "word",
                "worden",
                "wordt",
                "zal",
                "ze",
                "zei",
                "zeker",
                "zelf",
                "zelfde",
                "zelfs",
                "zes",
                "zeven",
                "zich",
                "zichzelf",
                "zij",
                "zijn",
                "zijne",
                "zijzelf",
                "zo",
                "zoals",
                "zodat",
                "zodra",
                "zonder",
                "zou",
                "zouden",
                "zowat",
                "zulk",
                "zulke",
                "zullen",
                "zult"
        ));
    }
}
