/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.dizitart.no2.fulltext.TextIndexingService;
import org.dizitart.no2.fulltext.TextTokenizer;
import org.dizitart.no2.mapper.JacksonMapper;
import org.dizitart.no2.mapper.NitriteMapper;
import org.dizitart.no2.util.ExecutorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NitriteContext {
    private static final Logger log = LoggerFactory.getLogger(NitriteContext.class);
    private String filePath;
    private int autoCommitBufferSize;
    private boolean inMemory;
    private boolean readOnly;
    private boolean compressed;
    private boolean autoCommitEnabled;
    private boolean autoCompactEnabled;
    private TextIndexingService textIndexingService;
    private TextTokenizer textTokenizer;
    private ExecutorService workerPool = ExecutorUtils.daemonExecutor();
    private ScheduledExecutorService scheduledWorkerPool = ExecutorUtils.scheduledExecutor();
    private NitriteMapper nitriteMapper;
    private Set<String> collectionRegistry;
    private Set<Class<?>> repositoryRegistry;

    NitriteContext() {
    }

    public NitriteMapper getNitriteMapper() {
        if (this.nitriteMapper == null) {
            this.nitriteMapper = new JacksonMapper();
        }
        return this.nitriteMapper;
    }

    void shutdown() {
        ExecutorUtils.shutdownAndAwaitTermination(this.scheduledWorkerPool, 5);
        ExecutorUtils.shutdownAndAwaitTermination(this.workerPool, 5);
        this.collectionRegistry.clear();
        this.repositoryRegistry.clear();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getAutoCommitBufferSize() {
        return this.autoCommitBufferSize;
    }

    public boolean isInMemory() {
        return this.inMemory;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public boolean isAutoCommitEnabled() {
        return this.autoCommitEnabled;
    }

    public boolean isAutoCompactEnabled() {
        return this.autoCompactEnabled;
    }

    public TextIndexingService getTextIndexingService() {
        return this.textIndexingService;
    }

    public TextTokenizer getTextTokenizer() {
        return this.textTokenizer;
    }

    public ExecutorService getWorkerPool() {
        return this.workerPool;
    }

    public ScheduledExecutorService getScheduledWorkerPool() {
        return this.scheduledWorkerPool;
    }

    void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    void setAutoCommitBufferSize(int autoCommitBufferSize) {
        this.autoCommitBufferSize = autoCommitBufferSize;
    }

    void setInMemory(boolean inMemory) {
        this.inMemory = inMemory;
    }

    void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    void setAutoCommitEnabled(boolean autoCommitEnabled) {
        this.autoCommitEnabled = autoCommitEnabled;
    }

    void setAutoCompactEnabled(boolean autoCompactEnabled) {
        this.autoCompactEnabled = autoCompactEnabled;
    }

    void setTextIndexingService(TextIndexingService textIndexingService) {
        this.textIndexingService = textIndexingService;
    }

    void setTextTokenizer(TextTokenizer textTokenizer) {
        this.textTokenizer = textTokenizer;
    }

    void setNitriteMapper(NitriteMapper nitriteMapper) {
        this.nitriteMapper = nitriteMapper;
    }

    Set<String> getCollectionRegistry() {
        return this.collectionRegistry;
    }

    void setCollectionRegistry(Set<String> collectionRegistry) {
        this.collectionRegistry = collectionRegistry;
    }

    Set<Class<?>> getRepositoryRegistry() {
        return this.repositoryRegistry;
    }

    void setRepositoryRegistry(Set<Class<?>> repositoryRegistry) {
        this.repositoryRegistry = repositoryRegistry;
    }
}

