/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.dizitart.no2.Document;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.filters.BaseFilter;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.DocumentUtils;
import org.dizitart.no2.util.EqualsUtils;

class EqualsFilter
extends BaseFilter {
    private String field;
    private Object value;

    EqualsFilter(String field, Object value) {
        this.field = field;
        this.value = value;
    }

    @Override
    public Set<NitriteId> apply(NitriteMap<NitriteId, Document> documentMap) {
        if (this.field.equals("_id")) {
            LinkedHashSet<NitriteId> nitriteIdSet = new LinkedHashSet<NitriteId>();
            NitriteId nitriteId = null;
            if (this.value instanceof Long) {
                nitriteId = NitriteId.createId((Long)this.value);
            }
            if (nitriteId != null && documentMap.containsKey(nitriteId)) {
                nitriteIdSet.add(nitriteId);
            }
            return nitriteIdSet;
        }
        if (this.nitriteService.hasIndex(this.field) && !this.nitriteService.isIndexing(this.field) && this.value != null) {
            return this.nitriteService.findEqualWithIndex(this.field, this.value);
        }
        return this.matchedSet(documentMap);
    }

    private Set<NitriteId> matchedSet(NitriteMap<NitriteId, Document> documentMap) {
        LinkedHashSet<NitriteId> nitriteIdSet = new LinkedHashSet<NitriteId>();
        for (Map.Entry<NitriteId, Document> entry : documentMap.entrySet()) {
            Document document = entry.getValue();
            Object fieldValue = DocumentUtils.getFieldValue(document, this.field);
            if (!EqualsUtils.deepEquals(fieldValue, this.value)) continue;
            nitriteIdSet.add(entry.getKey());
        }
        return nitriteIdSet;
    }

    public String getField() {
        return this.field;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "EqualsFilter(field=" + this.getField() + ", value=" + this.getValue() + ")";
    }
}

