/*
 *
 * Copyright 2017 Nitrite author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.dizitart.no2.sync.data;

import lombok.AllArgsConstructor;
import lombok.Data;

import java.io.Serializable;

/**
 * The DataGate server online operation response.
 *
 * @author Anindya Chatterjee.
 * @since 1.0
 */
@Data
@AllArgsConstructor
public class OnlineResponse implements Serializable {
    private static final long serialVersionUID = 1487243044L;

    /**
     * The boolean value indicating whether the server
     * is online or not.
     *
     * @param online the boolean value
     * @return `true` if online; `false` otherwise.
     * */
    private boolean online;

    /**
     * Instantiates a new {@link OnlineResponse}.
     */
    public OnlineResponse(){}
}
