/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.NitriteContext;
import org.dizitart.no2.NitriteShutDownHook;
import org.dizitart.no2.Security;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.exceptions.SecurityException;
import org.dizitart.no2.fulltext.EnglishTextTokenizer;
import org.dizitart.no2.fulltext.TextIndexingService;
import org.dizitart.no2.fulltext.TextTokenizer;
import org.dizitart.no2.mapper.NitriteMapper;
import org.dizitart.no2.store.NitriteMVStore;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.tool.Recovery;
import org.dizitart.no2.util.ObjectUtils;
import org.dizitart.no2.util.StringUtils;
import org.dizitart.no2.util.ValidationUtils;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NitriteBuilder {
    private static final Logger log = LoggerFactory.getLogger(NitriteBuilder.class);
    private String filePath;
    private int autoCommitBufferSize;
    private boolean readOnly;
    private boolean compress;
    private boolean autoCommit = true;
    private boolean autoCompact = true;
    private boolean shutdownHook = true;
    private TextIndexingService textIndexingService;
    private TextTokenizer textTokenizer;
    private NitriteMapper nitriteMapper;

    NitriteBuilder() {
    }

    public NitriteBuilder filePath(String path) {
        this.filePath = path;
        return this;
    }

    public NitriteBuilder filePath(File file) {
        this.filePath = file == null ? null : file.getPath();
        return this;
    }

    public NitriteBuilder autoCommitBufferSize(int size) {
        this.autoCommitBufferSize = size;
        return this;
    }

    public NitriteBuilder readOnly() {
        this.readOnly = true;
        return this;
    }

    public NitriteBuilder compressed() {
        this.compress = true;
        return this;
    }

    public NitriteBuilder disableAutoCommit() {
        this.autoCommit = false;
        return this;
    }

    public NitriteBuilder disableAutoCompact() {
        this.autoCompact = false;
        return this;
    }

    public NitriteBuilder textIndexingService(TextIndexingService textIndexingService) {
        this.textIndexingService = textIndexingService;
        return this;
    }

    public NitriteBuilder textTokenizer(TextTokenizer textTokenizer) {
        this.textTokenizer = textTokenizer;
        return this;
    }

    public NitriteBuilder nitriteMapper(NitriteMapper nitriteMapper) {
        this.nitriteMapper = nitriteMapper;
        return this;
    }

    public NitriteBuilder disableShutdownHook() {
        this.shutdownHook = false;
        return this;
    }

    public Nitrite openOrCreate() {
        return this.openOrCreateInternal(null, null);
    }

    public Nitrite openOrCreate(String userId, String password) {
        if (StringUtils.isNullOrEmpty(userId)) {
            throw new SecurityException(ErrorMessage.USER_ID_IS_EMPTY);
        }
        if (StringUtils.isNullOrEmpty(password)) {
            throw new SecurityException(ErrorMessage.PASSWORD_IS_EMPTY);
        }
        return this.openOrCreateInternal(userId, password);
    }

    private Nitrite openOrCreateInternal(String userId, String password) {
        MVStore store;
        block28: {
            MVStore.Builder builder = new MVStore.Builder();
            if (!StringUtils.isNullOrEmpty(this.filePath)) {
                builder = builder.fileName(this.filePath);
            }
            if (this.autoCommitBufferSize > 0) {
                builder = builder.autoCommitBufferSize(this.autoCommitBufferSize);
            }
            if (this.readOnly) {
                if (StringUtils.isNullOrEmpty(this.filePath)) {
                    throw new InvalidOperationException(ErrorMessage.UNABLE_TO_CREATE_IN_MEMORY_READONLY_DB);
                }
                builder = builder.readOnly();
            }
            if (this.compress) {
                builder = builder.compress();
            }
            if (!this.autoCommit) {
                builder = builder.autoCommitDisabled();
            }
            builder.autoCompactFillRate(0);
            store = null;
            File dbFile = null;
            try {
                store = !StringUtils.isNullOrEmpty(this.filePath) ? ((dbFile = new File(this.filePath)).exists() ? Security.openSecurely(builder, userId, password) : Security.createSecurely(builder, userId, password)) : Security.createSecurely(builder, userId, password);
            }
            catch (IllegalStateException ise) {
                if (ise.getMessage().contains("file is locked")) {
                    throw new NitriteIOException(ErrorMessage.DATABASE_OPENED_IN_OTHER_PROCESS);
                }
                if (!StringUtils.isNullOrEmpty(this.filePath)) {
                    try {
                        File file = new File(this.filePath);
                        if (file.exists() && file.isFile()) {
                            log.error("Database corruption detected. Trying to repair", (Throwable)ise);
                            Recovery.recover(this.filePath);
                            store = builder.open();
                        } else if (this.readOnly) {
                            throw new NitriteIOException(ErrorMessage.FAILED_TO_CREATE_IN_MEMORY_READONLY_DB, (Throwable)ise);
                        }
                        break block28;
                    }
                    catch (InvalidOperationException ioe) {
                        throw ioe;
                    }
                    catch (Exception e) {
                        throw new NitriteIOException(ErrorMessage.UNABLE_TO_REPAIR_DB, (Throwable)e);
                    }
                }
                throw new NitriteIOException(ErrorMessage.UNABLE_TO_CREATE_IN_MEMORY_DB, (Throwable)ise);
            }
            catch (IllegalArgumentException iae) {
                if (dbFile != null && !dbFile.getParentFile().exists()) {
                    throw new NitriteIOException(ErrorMessage.errorMessage("Directory " + dbFile.getParent() + " does not exists", 2012), (Throwable)iae);
                }
                throw new NitriteIOException(ErrorMessage.UNABLE_TO_CREATE_DB_FILE, (Throwable)iae);
            }
            finally {
                if (store != null) {
                    store.setRetentionTime(-1);
                    store.setVersionsToKeep(2);
                    store.setReuseSpace(true);
                }
            }
        }
        if (store != null) {
            NitriteContext context = new NitriteContext();
            context.setTextIndexingService(this.textIndexingService);
            if (this.textTokenizer == null) {
                this.textTokenizer = new EnglishTextTokenizer();
            }
            context.setTextTokenizer(this.textTokenizer);
            context.setFilePath(this.filePath);
            if (this.autoCommitBufferSize > 0) {
                context.setAutoCommitBufferSize(this.autoCommitBufferSize);
            } else {
                context.setAutoCommitBufferSize(1024);
            }
            context.setInMemory(StringUtils.isNullOrEmpty(this.filePath));
            context.setReadOnly(this.readOnly);
            context.setCompressed(this.compress);
            context.setAutoCommitEnabled(this.autoCommit);
            context.setAutoCompactEnabled(this.autoCompact);
            context.setNitriteMapper(this.nitriteMapper);
            NitriteMVStore nitriteStore = new NitriteMVStore(store);
            context.setCollectionRegistry(this.populateCollections(nitriteStore));
            context.setRepositoryRegistry(this.populateRepositories(nitriteStore));
            Nitrite db = new Nitrite(nitriteStore, context);
            if (this.shutdownHook) {
                Runtime.getRuntime().addShutdownHook(new NitriteShutDownHook(db));
            }
            return db;
        }
        return null;
    }

    private Set<String> populateCollections(NitriteStore store) {
        HashSet<String> collectionRegistry = new HashSet<String>();
        if (store != null) {
            for (String name : store.getMapNames()) {
                if (!ValidationUtils.isValidCollectionName(name) || ObjectUtils.isObjectStore(name)) continue;
                collectionRegistry.add(name);
            }
        } else {
            log.error("Underlying store is null. Nitrite has not been initialized properly.");
        }
        return collectionRegistry;
    }

    private Set<Class<?>> populateRepositories(NitriteStore store) {
        HashSet repositoryRegistry = new HashSet();
        if (store != null) {
            for (String name : store.getMapNames()) {
                if (!ValidationUtils.isValidCollectionName(name) || !ObjectUtils.isObjectStore(name)) continue;
                try {
                    repositoryRegistry.add(Class.forName(name));
                }
                catch (ClassNotFoundException e) {
                    log.error("Could not find the class " + name);
                }
            }
        } else {
            log.error("Underlying store is null. Nitrite has not been initialized properly.");
        }
        return repositoryRegistry;
    }
}

