/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.objects;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.dizitart.no2.Document;
import org.dizitart.no2.FindOptions;
import org.dizitart.no2.IndexOptions;
import org.dizitart.no2.IndexType;
import org.dizitart.no2.KeyValuePair;
import org.dizitart.no2.NitriteCollection;
import org.dizitart.no2.NitriteContext;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.RemoveOptions;
import org.dizitart.no2.UpdateOptions;
import org.dizitart.no2.WriteResult;
import org.dizitart.no2.event.ChangeListener;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.NotIdentifiableException;
import org.dizitart.no2.exceptions.ValidationException;
import org.dizitart.no2.mapper.NitriteMapper;
import org.dizitart.no2.meta.Attributes;
import org.dizitart.no2.objects.Cursor;
import org.dizitart.no2.objects.Index;
import org.dizitart.no2.objects.ObjectCursor;
import org.dizitart.no2.objects.ObjectFilter;
import org.dizitart.no2.objects.ObjectRepository;
import org.dizitart.no2.util.ObjectUtils;
import org.dizitart.no2.util.ValidationUtils;

class DefaultObjectRepository<T>
implements ObjectRepository<T> {
    private NitriteCollection collection;
    private Class<T> type;
    private NitriteMapper nitriteMapper;
    private Field idField;

    DefaultObjectRepository(Class<T> type, NitriteCollection collection, NitriteContext nitriteContext) {
        this.type = type;
        this.collection = collection;
        this.initRepository(nitriteContext);
    }

    @Override
    public void createIndex(String field, IndexOptions indexOptions) {
        this.validateCollection();
        ValidationUtils.notNull(field, ErrorMessage.errorMessage("field can not be null", 1069));
        this.collection.createIndex(field, indexOptions);
    }

    @Override
    public void rebuildIndex(String field, boolean async) {
        this.validateCollection();
        this.collection.rebuildIndex(field, async);
    }

    @Override
    public Collection<org.dizitart.no2.Index> listIndices() {
        this.validateCollection();
        return this.collection.listIndices();
    }

    @Override
    public boolean hasIndex(String field) {
        this.validateCollection();
        return this.collection.hasIndex(field);
    }

    @Override
    public boolean isIndexing(String field) {
        this.validateCollection();
        return this.collection.isIndexing(field);
    }

    @Override
    public void dropIndex(String field) {
        this.validateCollection();
        this.collection.dropIndex(field);
    }

    @Override
    public void dropAllIndices() {
        this.validateCollection();
        this.collection.dropAllIndices();
    }

    @Override
    @SafeVarargs
    public final WriteResult insert(T object, T ... others) {
        this.validateCollection();
        return this.collection.insert(this.asDocument(object, false), this.asDocuments(others, false));
    }

    @Override
    public WriteResult insert(T[] objects) {
        this.validateCollection();
        return this.collection.insert(this.asDocuments(objects, false));
    }

    @Override
    public WriteResult update(T element) {
        return this.update(element, false);
    }

    @Override
    public WriteResult update(T element, boolean upsert) {
        if (this.idField == null) {
            throw new NotIdentifiableException(ErrorMessage.OBJ_UPDATE_FAILED_AS_NO_ID_FOUND);
        }
        return this.update(ObjectUtils.createUniqueFilter(element, this.idField), element, upsert);
    }

    @Override
    public WriteResult update(ObjectFilter filter, T update) {
        return this.update(filter, update, false);
    }

    @Override
    public WriteResult update(ObjectFilter filter, T update, boolean upsert) {
        this.validateCollection();
        ValidationUtils.notNull(update, ErrorMessage.errorMessage("update can not be null", 1070));
        Document updateDocument = this.asDocument(update, true);
        this.removeIdFields(updateDocument);
        return this.collection.update(this.prepare(filter), updateDocument, UpdateOptions.updateOptions(upsert, true));
    }

    @Override
    public WriteResult update(ObjectFilter filter, Document update) {
        return this.update(filter, update, false);
    }

    @Override
    public WriteResult update(ObjectFilter filter, Document update, boolean justOnce) {
        this.validateCollection();
        ValidationUtils.notNull(update, ErrorMessage.errorMessage("update can not be null", 1071));
        this.removeIdFields(update);
        this.serializeFields(update);
        return this.collection.update(this.prepare(filter), update, UpdateOptions.updateOptions(false, justOnce));
    }

    @Override
    public WriteResult remove(T element) {
        if (this.idField == null) {
            throw new NotIdentifiableException(ErrorMessage.OBJ_REMOVE_FAILED_AS_NO_ID_FOUND);
        }
        return this.remove(ObjectUtils.createUniqueFilter(element, this.idField));
    }

    @Override
    public WriteResult remove(ObjectFilter filter) {
        this.validateCollection();
        return this.remove(this.prepare(filter), new RemoveOptions());
    }

    @Override
    public WriteResult remove(ObjectFilter filter, RemoveOptions removeOptions) {
        this.validateCollection();
        return this.collection.remove(this.prepare(filter), removeOptions);
    }

    @Override
    public Cursor<T> find() {
        this.validateCollection();
        return new ObjectCursor<T>(this.nitriteMapper, this.collection.find(), this.type);
    }

    @Override
    public Cursor<T> find(ObjectFilter filter) {
        this.validateCollection();
        return new ObjectCursor<T>(this.nitriteMapper, this.collection.find(this.prepare(filter)), this.type);
    }

    @Override
    public Cursor<T> find(FindOptions findOptions) {
        this.validateCollection();
        return new ObjectCursor<T>(this.nitriteMapper, this.collection.find(findOptions), this.type);
    }

    @Override
    public Cursor<T> find(ObjectFilter filter, FindOptions findOptions) {
        this.validateCollection();
        return new ObjectCursor<T>(this.nitriteMapper, this.collection.find(this.prepare(filter), findOptions), this.type);
    }

    @Override
    public T getById(NitriteId nitriteId) {
        this.validateCollection();
        Document document = new Document((Map)this.collection.getById(nitriteId));
        document.remove("_id");
        return this.nitriteMapper.asObject(document, this.type);
    }

    @Override
    public void drop() {
        this.validateCollection();
        this.collection.drop();
    }

    @Override
    public boolean isDropped() {
        this.validateCollection();
        return this.collection.isDropped();
    }

    @Override
    public String getName() {
        return this.collection.getName();
    }

    @Override
    public long size() {
        this.validateCollection();
        return this.collection.size();
    }

    @Override
    public boolean isClosed() {
        this.validateCollection();
        return this.collection.isClosed();
    }

    @Override
    public void close() {
        this.validateCollection();
        this.collection.close();
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public NitriteCollection getDocumentCollection() {
        return this.collection;
    }

    @Override
    public Attributes getAttributes() {
        return this.collection.getAttributes();
    }

    @Override
    public void setAttributes(Attributes attributes) {
        this.collection.setAttributes(attributes);
    }

    @Override
    public void register(ChangeListener listener) {
        this.collection.register(listener);
    }

    @Override
    public void deregister(ChangeListener listener) {
        this.collection.deregister(listener);
    }

    private void validateCollection() {
        if (this.collection == null) {
            throw new ValidationException(ErrorMessage.REPOSITORY_NOT_INITIALIZED);
        }
    }

    private Document asDocument(T object, boolean update) {
        return ObjectUtils.toDocument(object, this.nitriteMapper, this.idField, update);
    }

    private Document[] asDocuments(T[] others, boolean update) {
        if (others == null || others.length == 0) {
            return null;
        }
        Document[] documents = new Document[others.length];
        for (int i = 0; i < others.length; ++i) {
            documents[i] = this.asDocument(others[i], update);
        }
        return documents;
    }

    private void initRepository(NitriteContext nitriteContext) {
        this.nitriteMapper = nitriteContext.getNitriteMapper();
        this.createIndexes();
    }

    private void createIndexes() {
        this.validateCollection();
        Set<Index> indexes = ObjectUtils.extractIndices(this.nitriteMapper, this.type);
        for (Index idx : indexes) {
            if (this.collection.hasIndex(idx.value())) continue;
            this.collection.createIndex(idx.value(), IndexOptions.indexOptions(idx.type(), false));
        }
        this.idField = ObjectUtils.getIdField(this.nitriteMapper, this.type);
        if (this.idField != null && !this.collection.hasIndex(this.idField.getName())) {
            this.collection.createIndex(this.idField.getName(), IndexOptions.indexOptions(IndexType.Unique));
        }
    }

    private ObjectFilter prepare(ObjectFilter objectFilter) {
        if (objectFilter != null) {
            objectFilter.setNitriteMapper(this.nitriteMapper);
            return objectFilter;
        }
        return null;
    }

    private void removeIdFields(Document document) {
        document.remove("_id");
        if (this.idField != null && this.idField.getType() == NitriteId.class) {
            document.remove(this.idField.getName());
        }
    }

    private void serializeFields(Document document) {
        if (document != null) {
            for (KeyValuePair keyValuePair : document) {
                String key = keyValuePair.getKey();
                Object value = keyValuePair.getValue();
                Object serializedValue = this.nitriteMapper.isValueType(value) ? this.nitriteMapper.asValue(value) : this.nitriteMapper.asDocument(value);
                document.put(key, serializedValue);
            }
        }
    }
}

