/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.sync;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.dizitart.no2.Document;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.SyncException;
import org.dizitart.no2.sync.DataGateClient;
import org.dizitart.no2.sync.SyncTemplate;
import org.dizitart.no2.sync.TimeSpan;
import org.dizitart.no2.sync.data.ChangeFeed;
import org.dizitart.no2.sync.data.ChangeResponse;
import org.dizitart.no2.sync.data.FeedOptions;
import org.dizitart.no2.sync.data.FetchResponse;
import org.dizitart.no2.sync.data.OnlineResponse;
import org.dizitart.no2.sync.data.SizeResponse;
import org.dizitart.no2.sync.data.TryLockResponse;
import org.dizitart.no2.util.ResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataGateSyncTemplate
implements SyncTemplate {
    private static final Logger log = LoggerFactory.getLogger(DataGateSyncTemplate.class);
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private String serviceUrl;
    private String collection;
    private DataGateClient dataGateClient;
    private ObjectMapper objectMapper;

    public DataGateSyncTemplate(DataGateClient dataGateClient, String collection) {
        this.dataGateClient = dataGateClient;
        this.collection = collection;
        this.serviceUrl = "/datagate/api/v1/collection/" + collection;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public ChangeFeed changedSince(FeedOptions feedOptions) {
        String url = this.dataGateClient.getServerBaseUrl() + this.serviceUrl + "/changedSince";
        OkHttpClient httpClient = this.dataGateClient.getHttpClient();
        try (Response response = null;){
            String jsonOptions = this.objectMapper.writeValueAsString((Object)feedOptions);
            Request request = new Request.Builder().url(url).post(RequestBody.create((MediaType)JSON, (String)jsonOptions)).build();
            response = httpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new SyncException(ErrorMessage.errorMessage(ResponseUtils.errorResponse(response), 11016));
            }
            ChangeFeed changeFeed = (ChangeFeed)this.objectMapper.readValue(response.body().bytes(), ChangeFeed.class);
            return changeFeed;
        }
    }

    @Override
    public boolean change(ChangeFeed changeFeed) {
        String url = this.dataGateClient.getServerBaseUrl() + this.serviceUrl + "/change";
        OkHttpClient httpClient = this.dataGateClient.getHttpClient();
        try (Response response = null;){
            String jsonFeed = this.objectMapper.writeValueAsString((Object)changeFeed);
            Request request = new Request.Builder().url(url).post(RequestBody.create((MediaType)JSON, (String)jsonFeed)).build();
            response = httpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new SyncException(ErrorMessage.errorMessage(ResponseUtils.errorResponse(response), 11017));
            }
            ChangeResponse changeResponse = (ChangeResponse)this.objectMapper.readValue(response.body().bytes(), ChangeResponse.class);
            boolean bl = changeResponse.isChanged();
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Document> fetch(int offset, int limit) {
        String url = this.dataGateClient.getServerBaseUrl() + this.serviceUrl + "/fetch/offset/" + offset + "/limit/" + limit;
        OkHttpClient httpClient = this.dataGateClient.getHttpClient();
        Request request = new Request.Builder().url(url).get().build();
        try (Response response = httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new SyncException(ErrorMessage.errorMessage(ResponseUtils.errorResponse(response), 11018));
            }
            FetchResponse fetchResponse = (FetchResponse)this.objectMapper.readValue(response.body().bytes(), FetchResponse.class);
            List<Document> list = fetchResponse.getDocuments();
            return list;
        }
        catch (Exception e) {
            log.error("Remote error while fetching document from remote", (Throwable)e);
            throw new SyncException(ErrorMessage.SYNC_FETCH_REMOTE_ERROR, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long size() {
        String url = this.dataGateClient.getServerBaseUrl() + this.serviceUrl + "/size";
        OkHttpClient httpClient = this.dataGateClient.getHttpClient();
        Request request = new Request.Builder().url(url).get().build();
        try (Response response = httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new SyncException(ErrorMessage.errorMessage(ResponseUtils.errorResponse(response), 11019));
            }
            SizeResponse sizeResponse = (SizeResponse)this.objectMapper.readValue(response.body().bytes(), SizeResponse.class);
            long l = sizeResponse.getSize();
            return l;
        }
        catch (Exception e) {
            log.error("Remote error while getting the size of the collection", (Throwable)e);
            throw new SyncException(ErrorMessage.SYNC_GET_SIZE_REMOTE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void clear() {
        String url = this.dataGateClient.getServerBaseUrl() + this.serviceUrl + "/clear";
        OkHttpClient httpClient = this.dataGateClient.getHttpClient();
        Request request = new Request.Builder().url(url).delete().build();
        try (Response response = httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new SyncException(ErrorMessage.errorMessage(ResponseUtils.errorResponse(response), 11008));
            }
        }
        catch (SyncException se) {
            throw se;
        }
        catch (Exception e) {
            log.error("Remote error while getting change feed from remote", (Throwable)e);
            throw new SyncException(ErrorMessage.SYNC_CLEAR_REMOTE_ERROR, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isOnline() {
        String url = this.dataGateClient.getServerBaseUrl() + "/datagate/api/v1/ping";
        OkHttpClient httpClient = this.dataGateClient.getHttpClient();
        Request request = new Request.Builder().url(url).get().build();
        try (Response response = httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new SyncException(ErrorMessage.errorMessage(ResponseUtils.errorResponse(response), 11020));
            }
            OnlineResponse onlineResponse = (OnlineResponse)this.objectMapper.readValue(response.body().bytes(), OnlineResponse.class);
            boolean bl = onlineResponse.isOnline();
            return bl;
        }
        catch (Exception e) {
            log.error("Remote error while getting online status", (Throwable)e);
            return false;
        }
    }

    @Override
    public String getCollectionName() {
        return this.collection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean trySyncLock(TimeSpan expiryDelay, String issuer) {
        long delay = TimeUnit.MILLISECONDS.convert(expiryDelay.getTime(), expiryDelay.getTimeUnit());
        String url = this.dataGateClient.getServerBaseUrl() + this.serviceUrl + "/tryLock/issuer/" + issuer + "/delay/" + delay;
        OkHttpClient httpClient = this.dataGateClient.getHttpClient();
        Request request = new Request.Builder().url(url).get().build();
        try (Response response = httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new SyncException(ErrorMessage.errorMessage(ResponseUtils.errorResponse(response), 11021));
            }
            TryLockResponse tryLockResponse = (TryLockResponse)this.objectMapper.readValue(response.body().bytes(), TryLockResponse.class);
            boolean bl = tryLockResponse.isLockAcquired();
            return bl;
        }
        catch (Exception e) {
            log.error("Remote error while acquiring lock", (Throwable)e);
            throw new SyncException(ErrorMessage.SYNC_TRY_LOCK_REMOTE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void releaseLock(String issuer) {
        String url = this.dataGateClient.getServerBaseUrl() + this.serviceUrl + "/releaseLock/issuer/" + issuer;
        OkHttpClient httpClient = this.dataGateClient.getHttpClient();
        Request request = new Request.Builder().url(url).get().build();
        try (Response response = httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new SyncException(ErrorMessage.errorMessage(ResponseUtils.errorResponse(response), 11013));
            }
        }
        catch (SyncException se) {
            throw se;
        }
        catch (Exception e) {
            log.error("Remote error while releasing lock from collection", (Throwable)e);
            throw new SyncException(ErrorMessage.SYNC_RELEASE_LOCK_REMOTE_ERROR, (Throwable)e);
        }
    }
}

