/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.sync;

import java.util.ArrayList;
import java.util.List;
import org.dizitart.no2.Cursor;
import org.dizitart.no2.Document;
import org.dizitart.no2.NitriteCollection;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.filters.Filters;
import org.dizitart.no2.meta.Attributes;
import org.dizitart.no2.sync.data.ChangeFeed;
import org.dizitart.no2.util.DocumentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalCollection {
    private static final Logger log = LoggerFactory.getLogger(LocalCollection.class);
    private NitriteCollection changeLogRepository;
    private NitriteCollection collection;

    LocalCollection(NitriteCollection collection) {
        this.collection = collection;
    }

    Attributes getAttributes() {
        return this.collection.getAttributes();
    }

    void setAttributes(Attributes attributes) {
        this.collection.setAttributes(attributes);
    }

    void change(ChangeFeed changeFeed) {
        if (changeFeed.getRemovedDocuments() != null) {
            this.remove(changeFeed.getRemovedDocuments());
        }
        if (changeFeed.getModifiedDocuments() != null) {
            this.modify(changeFeed.getModifiedDocuments());
        }
    }

    public void clear() {
        this.collection.remove(Filters.ALL);
    }

    public void insert(Document[] documents) {
        this.collection.insert(documents);
    }

    public String getName() {
        return this.collection.getName();
    }

    ChangeFeed changedSince(long lastSequence, long newSequence) {
        ChangeFeed changeFeed = new ChangeFeed();
        changeFeed.setRemovedDocuments(this.removedSince(lastSequence, newSequence));
        changeFeed.setModifiedDocuments(this.modifiedSince(lastSequence, newSequence));
        return changeFeed;
    }

    private void remove(List<Document> removed) {
        for (Document document : removed) {
            Document localDocument = (Document)this.collection.getById(document.getId());
            if (localDocument == null || !DocumentUtils.isRecent(document, localDocument)) continue;
            this.collection.remove(DocumentUtils.createUniqueFilter(document));
        }
    }

    private void modify(List<Document> modifiedDocuments) {
        for (Document doc : modifiedDocuments) {
            Document document = new Document(doc);
            document.put("_source", (Object)"Replicator.NO\u2082");
            Document localDocument = this.getLocalDocument(document);
            if (localDocument != null) {
                if (!DocumentUtils.isRecent(document, localDocument)) continue;
                localDocument.putAll(document);
                this.collection.update(localDocument);
                continue;
            }
            Cursor removeLogs = this.changeLogRepository.find(Filters.and(Filters.eq("collection", this.getName()), Filters.eq("deletedItem._id", document.getId().getIdValue()), Filters.gt("deleteTime", document.getLastModifiedTime())));
            if (removeLogs != null && removeLogs.size() != 0) continue;
            this.collection.insert(new Document[]{document});
        }
    }

    private Document getLocalDocument(Document document) {
        NitriteId id = document.getId();
        Document doc = (Document)this.collection.getById(id);
        if (doc != null) {
            return new Document(doc);
        }
        return null;
    }

    private List<Document> removedSince(long lastSequence, long newSequence) {
        Cursor removeLogs = this.changeLogRepository.find(Filters.and(Filters.eq("collection", this.getName()), Filters.gte("deleteTime", lastSequence), Filters.lte("deleteTime", newSequence)));
        ArrayList<Document> result = new ArrayList<Document>();
        if (removeLogs != null) {
            for (Document logEntry : removeLogs) {
                Document document = new Document(logEntry.get("deletedItem", Document.class));
                result.add(document);
            }
            log.debug("Removed since in " + this.getName() + ": from " + lastSequence + " now " + newSequence + " - " + result);
        }
        return result;
    }

    private List<Document> modifiedSince(long lastSequence, long newSequence) {
        Cursor findResult = this.collection.find(Filters.and(Filters.gte("_modified", lastSequence), Filters.lte("_modified", newSequence)));
        ArrayList<Document> result = new ArrayList<Document>();
        for (Document document : findResult) {
            Document doc = new Document(document);
            result.add(doc);
        }
        log.debug("Modified since in " + this.getName() + ": from " + lastSequence + " to " + newSequence + " - " + result);
        return result;
    }

    public NitriteCollection getChangeLogRepository() {
        return this.changeLogRepository;
    }

    public void setChangeLogRepository(NitriteCollection changeLogRepository) {
        this.changeLogRepository = changeLogRepository;
    }

    public NitriteCollection getCollection() {
        return this.collection;
    }
}

