/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.sync;

import java.lang.ref.WeakReference;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.ValidationException;
import org.dizitart.no2.sync.ReplicationType;
import org.dizitart.no2.sync.SyncEventListener;
import org.dizitart.no2.sync.SyncTemplate;
import org.dizitart.no2.sync.TimeSpan;

class SyncConfig {
    private ReplicationType replicationType = ReplicationType.BOTH_WAY;
    private TimeSpan syncDelay;
    private SyncTemplate syncTemplate;
    private WeakReference<SyncEventListener> syncEventListener;

    SyncConfig() {
    }

    SyncTemplate getSyncTemplate() {
        if (this.syncTemplate == null) {
            throw new ValidationException(ErrorMessage.SYNC_NO_REMOTE_COLLECTION);
        }
        return this.syncTemplate;
    }

    SyncEventListener getSyncEventListener() {
        if (this.syncEventListener != null && !this.syncEventListener.isEnqueued()) {
            return (SyncEventListener)this.syncEventListener.get();
        }
        return null;
    }

    void setSyncEventListener(SyncEventListener syncEventListener) {
        this.syncEventListener = new WeakReference<SyncEventListener>(syncEventListener);
    }

    ReplicationType getReplicationType() {
        return this.replicationType;
    }

    void setReplicationType(ReplicationType replicationType) {
        this.replicationType = replicationType;
    }

    TimeSpan getSyncDelay() {
        return this.syncDelay;
    }

    void setSyncDelay(TimeSpan syncDelay) {
        this.syncDelay = syncDelay;
    }

    public void setSyncTemplate(SyncTemplate syncTemplate) {
        this.syncTemplate = syncTemplate;
    }
}

