/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.internals;

import java.util.ArrayList;
import java.util.Collection;
import org.dizitart.no2.Cursor;
import org.dizitart.no2.Document;
import org.dizitart.no2.Filter;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.RemoveOptions;
import org.dizitart.no2.UpdateOptions;
import org.dizitart.no2.event.ChangeInfo;
import org.dizitart.no2.event.ChangeListener;
import org.dizitart.no2.event.ChangeType;
import org.dizitart.no2.event.ChangedItem;
import org.dizitart.no2.event.EventBus;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.exceptions.UniqueConstraintException;
import org.dizitart.no2.internals.IndexingService;
import org.dizitart.no2.internals.SearchService;
import org.dizitart.no2.internals.WriteResultImpl;
import org.dizitart.no2.store.NitriteMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataService {
    private static final Logger log = LoggerFactory.getLogger(DataService.class);
    private final IndexingService indexingService;
    private final SearchService searchService;
    private final NitriteMap<NitriteId, Document> underlyingMap;
    private final EventBus<ChangeInfo, ChangeListener> eventBus;
    private final String name;

    DataService(IndexingService indexingService, SearchService searchService, NitriteMap<NitriteId, Document> mapStore, EventBus<ChangeInfo, ChangeListener> eventBus) {
        this.indexingService = indexingService;
        this.searchService = searchService;
        this.underlyingMap = mapStore;
        this.eventBus = eventBus;
        this.name = this.underlyingMap.getName();
    }

    WriteResultImpl insert(Document ... documents) {
        ArrayList<NitriteId> nitriteIdList = new ArrayList<NitriteId>(documents.length);
        ArrayList<ChangedItem> changedItems = new ArrayList<ChangedItem>(documents.length);
        log.debug("Total {} document(s) to be inserted in {}", (Object)documents.length, (Object)this.name);
        for (Document document : documents) {
            NitriteId nitriteId = document.getId();
            if (!"Replicator.NO\u2082".contentEquals(document.getSource())) {
                document.remove("_source");
                document.put("_revision", (Object)1);
                document.put("_modified", (Object)System.currentTimeMillis());
            } else {
                document.remove("_source");
            }
            Document item = new Document(document);
            Document already = this.underlyingMap.putIfAbsent(nitriteId, item);
            log.debug("Inserting document {} in {}", (Object)document, (Object)this.name);
            if (already != null) {
                this.underlyingMap.put(nitriteId, already);
                log.debug("Another document already exists with id {}", (Object)nitriteId);
                throw new UniqueConstraintException(ErrorMessage.errorMessage("id constraint violation, entry with same id already exists in " + this.name, 10001));
            }
            try {
                this.indexingService.updateIndexEntry(item, nitriteId);
            }
            catch (UniqueConstraintException uce) {
                log.error("Unique constraint violated for the document " + document + " in " + this.name, (Throwable)uce);
                this.underlyingMap.remove(nitriteId);
                throw uce;
            }
            nitriteIdList.add(nitriteId);
            ChangedItem changedItem = new ChangedItem();
            changedItem.setDocument(document);
            changedItem.setChangeTimestamp(document.getLastModifiedTime());
            changedItem.setChangeType(ChangeType.INSERT);
            changedItems.add(changedItem);
        }
        this.notify(ChangeType.INSERT, changedItems);
        WriteResultImpl result = new WriteResultImpl();
        result.setNitriteIdList(nitriteIdList);
        log.debug("Returning write result {}  for collection {}", (Object)result, (Object)this.name);
        return result;
    }

    WriteResultImpl update(Filter filter, Document update, UpdateOptions updateOptions) {
        Cursor cursor = filter == null ? this.searchService.find() : this.searchService.find(filter);
        WriteResultImpl writeResult = new WriteResultImpl();
        if (cursor == null || cursor.size() == 0) {
            log.debug("No document found to update by the filter {}  in  {}", (Object)filter, (Object)this.name);
            if (updateOptions.isUpsert()) {
                return this.insert(update);
            }
            return writeResult;
        }
        if (cursor.size() > 1 && updateOptions.isJustOnce()) {
            throw new InvalidOperationException(ErrorMessage.OBJ_MULTI_UPDATE_WITH_JUST_ONCE);
        }
        update = new Document(update);
        update.remove("_id");
        if (!"Replicator.NO\u2082".contentEquals(update.getSource())) {
            update.remove("_revision");
        }
        if (update.size() == 0) {
            this.notify(ChangeType.UPDATE, null);
            return writeResult;
        }
        log.debug("Filter {} found total {} document(s) to update with options {} in {}", new Object[]{filter, cursor.size(), updateOptions, this.name});
        ArrayList<ChangedItem> changedItems = new ArrayList<ChangedItem>(cursor.size());
        for (Document document : cursor) {
            if (document == null) continue;
            NitriteId nitriteId = document.getId();
            Document oldDocument = new Document(document);
            log.debug("Document to update {} in {}", (Object)document, (Object)this.name);
            if (!"Replicator.NO\u2082".contentEquals(update.getSource())) {
                update.remove("_source");
                document.putAll(update);
                int rev = document.getRevision();
                document.put("_revision", (Object)(rev + 1));
                document.put("_modified", (Object)System.currentTimeMillis());
            } else {
                update.remove("_source");
                document.putAll(update);
            }
            Document item = new Document(document);
            this.underlyingMap.put(nitriteId, item);
            log.debug("Document {} updated in {}", (Object)document, (Object)this.name);
            if (update.size() > 0) {
                writeResult.addToList(nitriteId);
            }
            this.indexingService.refreshIndexEntry(oldDocument, item, nitriteId);
            ChangedItem changedItem = new ChangedItem();
            changedItem.setDocument(document);
            changedItem.setChangeType(ChangeType.UPDATE);
            changedItem.setChangeTimestamp(document.getLastModifiedTime());
            changedItems.add(changedItem);
        }
        this.notify(ChangeType.UPDATE, changedItems);
        log.debug("Returning write result {} for collection {}", (Object)writeResult, (Object)this.name);
        return writeResult;
    }

    WriteResultImpl remove(Filter filter, RemoveOptions removeOptions) {
        Cursor cursor = filter == null ? this.searchService.find() : this.searchService.find(filter);
        WriteResultImpl result = new WriteResultImpl();
        if (cursor == null) {
            log.debug("No document found to remove by the filter {} in {}", (Object)filter, (Object)this.name);
            return result;
        }
        log.debug("Filter {} found total {} document(s) to remove with options {} from {}", new Object[]{filter, cursor.size(), removeOptions, this.name});
        ArrayList<ChangedItem> changedItems = new ArrayList<ChangedItem>(cursor.size());
        for (Document document : cursor) {
            NitriteId nitriteId = document.getId();
            this.indexingService.removeIndexEntry(document, nitriteId);
            Document removed = this.underlyingMap.remove(nitriteId);
            int rev = removed.getRevision();
            removed.put("_revision", (Object)(rev + 1));
            removed.put("_modified", (Object)System.currentTimeMillis());
            log.debug("Document removed {} from {}", (Object)removed, (Object)this.name);
            result.addToList(nitriteId);
            ChangedItem changedItem = new ChangedItem();
            changedItem.setDocument(removed);
            changedItem.setChangeType(ChangeType.REMOVE);
            changedItem.setChangeTimestamp(removed.getLastModifiedTime());
            changedItems.add(changedItem);
            if (!removeOptions.isJustOne()) continue;
            this.notify(ChangeType.REMOVE, changedItems);
            return result;
        }
        this.notify(ChangeType.REMOVE, changedItems);
        log.debug("Returning write result {} for collection {}", (Object)result, (Object)this.name);
        return result;
    }

    Document getById(NitriteId nitriteId) {
        return this.underlyingMap.get(nitriteId);
    }

    private void notify(ChangeType action, Collection<ChangedItem> changedItems) {
        log.debug("Notifying {} event for items {} from {}", new Object[]{action, changedItems, this.name});
        if (this.eventBus != null) {
            ChangeInfo changeInfo = new ChangeInfo(action);
            changeInfo.setChangedItems(changedItems);
            this.eventBus.post(changeInfo);
        }
    }
}

