/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.internals;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dizitart.no2.Document;
import org.dizitart.no2.Index;
import org.dizitart.no2.IndexType;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.util.IndexUtils;

class IndexMetaService {
    private final NitriteMap<NitriteId, Document> underlyingMap;
    private final NitriteStore mvStore;

    IndexMetaService(NitriteMap<NitriteId, Document> underlyingMap) {
        this.underlyingMap = underlyingMap;
        this.mvStore = underlyingMap.getStore();
    }

    NitriteMap<NitriteId, Document> getUnderlyingMap() {
        return this.underlyingMap;
    }

    boolean hasIndex(String field) {
        return this.getIndexMetadata().containsKey(field) && this.getIndexMetadata().get(field) != null;
    }

    boolean hasTextIndex(String field) {
        return this.getIndexMetadata().containsKey(field) && this.getIndexMetadata().get(field).index.getIndexType() == IndexType.Fulltext;
    }

    Index findIndex(String field) {
        IndexMeta meta = this.getIndexMetadata().get(field);
        if (meta != null) {
            return meta.index;
        }
        return null;
    }

    NitriteMap<Comparable, ConcurrentSkipListSet<NitriteId>> getIndexMap(String field) {
        IndexMeta meta = this.getIndexMetadata().get(field);
        if (meta != null && meta.index != null) {
            return this.mvStore.openMap(meta.indexMap);
        }
        return null;
    }

    void markDirty(String field) {
        IndexMeta meta = this.getIndexMetadata().get(field);
        if (meta != null && meta.index != null) {
            meta.isDirty.set(true);
        }
    }

    void unmarkDirty(String field) {
        IndexMeta meta = this.getIndexMetadata().get(field);
        if (meta != null && meta.index != null) {
            meta.isDirty.set(false);
        }
    }

    synchronized boolean isDirtyIndex(String field) {
        IndexMeta meta = this.getIndexMetadata().get(field);
        return meta != null && meta.isDirty.get();
    }

    Collection<Index> listIndexes() {
        LinkedHashSet<Index> indexSet = new LinkedHashSet<Index>();
        for (IndexMeta indexMeta : this.getIndexMetadata().values()) {
            indexSet.add(indexMeta.index);
        }
        return Collections.unmodifiableSet(indexSet);
    }

    void dropIndex(String field) {
        IndexMeta meta = this.getIndexMetadata().get(field);
        if (meta == null || meta.index == null) {
            throw new IndexingException(ErrorMessage.errorMessage(field + " is not indexed", 5010));
        }
        String indexMapName = meta.indexMap;
        this.mvStore.removeMap(this.mvStore.openMap(indexMapName));
        this.getIndexMetadata().remove(field);
    }

    void dropAll() {
        for (String field : this.getIndexMetadata().keySet()) {
            if (field == null) continue;
            this.dropIndex(field);
        }
        this.mvStore.removeMap(this.getIndexMetadata());
    }

    Index createIndexMetadata(String field, IndexType indexType) {
        Index index = new Index(indexType, field, this.underlyingMap.getName());
        IndexMeta indexMeta = new IndexMeta();
        indexMeta.index = index;
        indexMeta.isDirty = new AtomicBoolean(false);
        indexMeta.indexMap = IndexUtils.internalName(index);
        this.getIndexMetadata().put(field, indexMeta);
        return index;
    }

    private String getName() {
        return "$nitrite_index_meta|" + this.underlyingMap.getName();
    }

    private NitriteMap<String, IndexMeta> getIndexMetadata() {
        String indexMetaName = this.getName();
        return this.mvStore.openMap(indexMetaName);
    }

    private static class IndexMeta
    implements Serializable {
        private Index index;
        private String indexMap;
        private AtomicBoolean isDirty;

        private IndexMeta() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndexMeta)) {
                return false;
            }
            IndexMeta other = (IndexMeta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Index this$index = this.index;
            Index other$index = other.index;
            if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
                return false;
            }
            String this$indexMap = this.indexMap;
            String other$indexMap = other.indexMap;
            if (this$indexMap == null ? other$indexMap != null : !this$indexMap.equals(other$indexMap)) {
                return false;
            }
            AtomicBoolean this$isDirty = this.isDirty;
            AtomicBoolean other$isDirty = other.isDirty;
            return !(this$isDirty == null ? other$isDirty != null : !this$isDirty.equals(other$isDirty));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IndexMeta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Index $index = this.index;
            result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
            String $indexMap = this.indexMap;
            result = result * 59 + ($indexMap == null ? 43 : $indexMap.hashCode());
            AtomicBoolean $isDirty = this.isDirty;
            result = result * 59 + ($isDirty == null ? 43 : $isDirty.hashCode());
            return result;
        }

        public String toString() {
            return "IndexMetaService.IndexMeta(index=" + this.index + ", indexMap=" + this.indexMap + ", isDirty=" + this.isDirty + ")";
        }
    }
}

