/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.objects.filters;

import java.util.Set;
import org.dizitart.no2.Document;
import org.dizitart.no2.Filter;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.filters.Filters;
import org.dizitart.no2.objects.filters.BaseObjectFilter;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.ValidationUtils;

class RegexObjectFilter
extends BaseObjectFilter {
    private String field;
    private String value;

    RegexObjectFilter(String field, String value) {
        this.field = field;
        this.value = value;
    }

    @Override
    public Set<NitriteId> apply(NitriteMap<NitriteId, Document> documentMap) {
        ValidationUtils.validateSearchTerm(this.nitriteMapper, this.field, this.value);
        Filter regex = Filters.regex(this.field, this.value);
        regex.setNitriteService(this.nitriteService);
        return regex.apply(documentMap);
    }

    public String getField() {
        return this.field;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "RegexObjectFilter(field=" + this.getField() + ", value=" + this.getValue() + ")";
    }
}

