/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.internals;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentSkipListSet;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.FilterException;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.fulltext.TextIndexingService;
import org.dizitart.no2.fulltext.TextTokenizer;
import org.dizitart.no2.internals.IndexMetaService;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.IndexUtils;

class NitriteTextIndexingService
implements TextIndexingService {
    private TextTokenizer tokenizerService;
    private IndexMetaService indexMetaService;
    private final Object indexLock = new Object();

    NitriteTextIndexingService(TextTokenizer textTokenizer, IndexMetaService indexMetaService) {
        this.tokenizerService = textTokenizer;
        this.indexMetaService = indexMetaService;
    }

    @Override
    public void createIndex(NitriteId id, String field, String text) {
        this.createOrUpdate(id, field, text);
    }

    @Override
    public void updateIndex(NitriteId id, String field, String text) {
        this.createOrUpdate(id, field, text);
    }

    @Override
    public void deleteIndex(NitriteId id, String field, String text) {
        try {
            NitriteMap<Comparable, ConcurrentSkipListSet<NitriteId>> indexMap = this.indexMetaService.getIndexMap(field);
            Set<String> words = this.tokenizerService.tokenize(text);
            for (String word : words) {
                ConcurrentSkipListSet<NitriteId> nitriteIds = indexMap.get((Comparable)((Object)word));
                if (nitriteIds == null) continue;
                nitriteIds.remove(id);
                if (nitriteIds.isEmpty()) {
                    indexMap.remove((Comparable)((Object)word));
                    continue;
                }
                indexMap.put((Comparable)((Object)word), nitriteIds);
            }
        }
        catch (IOException ioe) {
            throw new IndexingException(ErrorMessage.errorMessage("failed to remove full-text index data for " + field + " with id " + id, 5011));
        }
    }

    @Override
    public void deleteIndexesByField(String field) {
        this.indexMetaService.dropIndex(field);
    }

    @Override
    public Set<NitriteId> searchByIndex(String field, String searchString) {
        try {
            if (searchString.startsWith("*") || searchString.endsWith("*")) {
                return this.searchByWildCard(field, searchString);
            }
            return this.searchExactByIndex(field, searchString);
        }
        catch (IOException ioe) {
            throw new IndexingException(ErrorMessage.FAILED_TO_QUERY_FTS_DATA, (Throwable)ioe);
        }
    }

    @Override
    public void drop() {
    }

    @Override
    public void clear() {
    }

    @Override
    public void commit() {
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrUpdate(NitriteId id, String field, String text) {
        try {
            NitriteMap<Comparable, ConcurrentSkipListSet<NitriteId>> indexMap = this.indexMetaService.getIndexMap(field);
            Set<String> words = this.tokenizerService.tokenize(text);
            for (String word : words) {
                ConcurrentSkipListSet<NitriteId> nitriteIds = indexMap.get((Comparable)((Object)word));
                Object object = this.indexLock;
                synchronized (object) {
                    if (nitriteIds == null) {
                        nitriteIds = new ConcurrentSkipListSet();
                    }
                }
                nitriteIds.add(id);
                indexMap.put((Comparable)((Object)word), nitriteIds);
            }
        }
        catch (IOException ioe) {
            throw new IndexingException(ErrorMessage.errorMessage("could not write full-text index data for " + text, 5018), (Throwable)ioe);
        }
    }

    private Set<NitriteId> searchByWildCard(String field, String searchString) {
        if (searchString.contentEquals("*")) {
            throw new FilterException(ErrorMessage.STAR_NOT_A_VALID_SEARCH_STRING);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(searchString);
        if (stringTokenizer.countTokens() > 1) {
            throw new FilterException(ErrorMessage.MULTIPLE_WORDS_WITH_WILD_CARD);
        }
        if (searchString.startsWith("*") && !searchString.endsWith("*")) {
            return this.searchByLeadingWildCard(field, searchString);
        }
        if (searchString.endsWith("*") && !searchString.startsWith("*")) {
            return this.searchByTrailingWildCard(field, searchString);
        }
        String term = searchString.substring(1, searchString.length() - 1);
        return this.searchContains(field, term);
    }

    private Set<NitriteId> searchByTrailingWildCard(String field, String searchString) {
        if (searchString.equalsIgnoreCase("*")) {
            throw new FilterException(ErrorMessage.INVALID_SEARCH_TERM_TRAILING_STAR);
        }
        NitriteMap<Comparable, ConcurrentSkipListSet<NitriteId>> indexMap = this.indexMetaService.getIndexMap(field);
        LinkedHashSet<NitriteId> idSet = new LinkedHashSet<NitriteId>();
        String term = searchString.substring(0, searchString.length() - 1);
        for (Map.Entry<Comparable, ConcurrentSkipListSet<NitriteId>> entry : indexMap.entrySet()) {
            String key = (String)((Object)entry.getKey());
            if (!key.startsWith(term.toLowerCase())) continue;
            idSet.addAll((Collection<NitriteId>)entry.getValue());
        }
        return idSet;
    }

    private Set<NitriteId> searchContains(String field, String term) {
        NitriteMap<Comparable, ConcurrentSkipListSet<NitriteId>> indexMap = this.indexMetaService.getIndexMap(field);
        LinkedHashSet<NitriteId> idSet = new LinkedHashSet<NitriteId>();
        for (Map.Entry<Comparable, ConcurrentSkipListSet<NitriteId>> entry : indexMap.entrySet()) {
            String key = (String)((Object)entry.getKey());
            if (!key.contains(term.toLowerCase())) continue;
            idSet.addAll((Collection<NitriteId>)entry.getValue());
        }
        return idSet;
    }

    private Set<NitriteId> searchByLeadingWildCard(String field, String searchString) {
        if (searchString.equalsIgnoreCase("*")) {
            throw new FilterException(ErrorMessage.INVALID_SEARCH_TERM_LEADING_STAR);
        }
        NitriteMap<Comparable, ConcurrentSkipListSet<NitriteId>> indexMap = this.indexMetaService.getIndexMap(field);
        LinkedHashSet<NitriteId> idSet = new LinkedHashSet<NitriteId>();
        String term = searchString.substring(1);
        for (Map.Entry<Comparable, ConcurrentSkipListSet<NitriteId>> entry : indexMap.entrySet()) {
            String key = (String)((Object)entry.getKey());
            if (!key.endsWith(term.toLowerCase())) continue;
            idSet.addAll((Collection<NitriteId>)entry.getValue());
        }
        return idSet;
    }

    private Set<NitriteId> searchExactByIndex(String field, String searchString) throws IOException {
        NitriteMap<Comparable, ConcurrentSkipListSet<NitriteId>> indexMap = this.indexMetaService.getIndexMap(field);
        Set<String> words = this.tokenizerService.tokenize(searchString);
        HashMap<NitriteId, Integer> scoreMap = new HashMap<NitriteId, Integer>();
        for (String word : words) {
            ConcurrentSkipListSet<NitriteId> nitriteIds = indexMap.get((Comparable)((Object)word));
            if (nitriteIds == null) continue;
            for (NitriteId id : nitriteIds) {
                Integer score = (Integer)scoreMap.get(id);
                if (score == null) {
                    scoreMap.put(id, 1);
                    continue;
                }
                scoreMap.put(id, score + 1);
            }
        }
        Map sortedScoreMap = IndexUtils.sortByScore(scoreMap);
        return sortedScoreMap.keySet();
    }
}

