/*
 * Copyright (c) 2017-2020. Nitrite author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.dizitart.no2.index.fulltext.languages;

import org.dizitart.no2.index.fulltext.Language;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * Esperanto stop words
 *
 * @author Anindya Chatterjee
 * @since 2.1.0
 */
public class Esperanto implements Language {
    @Override
    public Set<String> stopWords() {
        return new HashSet<>(Arrays.asList(
            "adiaŭ",
            "ajn",
            "al",
            "ankoraŭ",
            "antaŭ",
            "aŭ",
            "bonan",
            "bonvole",
            "bonvolu",
            "bv",
            "ci",
            "cia",
            "cian",
            "cin",
            "d-ro",
            "da",
            "de",
            "dek",
            "deka",
            "do",
            "doktor'",
            "doktoro",
            "du",
            "dua",
            "dum",
            "eble",
            "ekz",
            "ekzemple",
            "en",
            "estas",
            "estis",
            "estos",
            "estu",
            "estus",
            "eĉ",
            "f-no",
            "feliĉan",
            "for",
            "fraŭlino",
            "ha",
            "havas",
            "havis",
            "havos",
            "havu",
            "havus",
            "he",
            "ho",
            "hu",
            "ili",
            "ilia",
            "ilian",
            "ilin",
            "inter",
            "io",
            "ion",
            "iu",
            "iujn",
            "iun",
            "ja",
            "jam",
            "je",
            "jes",
            "k",
            "kaj",
            "ke",
            "kio",
            "kion",
            "kiu",
            "kiujn",
            "kiun",
            "kvankam",
            "kvar",
            "kvara",
            "kvazaŭ",
            "kvin",
            "kvina",
            "la",
            "li",
            "lia",
            "lian",
            "lin",
            "malantaŭ",
            "male",
            "malgraŭ",
            "mem",
            "mi",
            "mia",
            "mian",
            "min",
            "minus",
            "naŭ",
            "naŭa",
            "ne",
            "nek",
            "nenio",
            "nenion",
            "neniu",
            "neniun",
            "nepre",
            "ni",
            "nia",
            "nian",
            "nin",
            "nu",
            "nun",
            "nur",
            "ok",
            "oka",
            "oni",
            "onia",
            "onian",
            "onin",
            "plej",
            "pli",
            "plu",
            "plus",
            "por",
            "post",
            "preter",
            "s-no",
            "s-ro",
            "se",
            "sed",
            "sep",
            "sepa",
            "ses",
            "sesa",
            "si",
            "sia",
            "sian",
            "sin",
            "sinjor'",
            "sinjorino",
            "sinjoro",
            "sub",
            "super",
            "supren",
            "sur",
            "tamen",
            "tio",
            "tion",
            "tiu",
            "tiujn",
            "tiun",
            "tra",
            "tri",
            "tria",
            "tuj",
            "tute",
            "unu",
            "unua",
            "ve",
            "verŝajne",
            "vi",
            "via",
            "vian",
            "vin",
            "ĉi",
            "ĉio",
            "ĉion",
            "ĉiu",
            "ĉiujn",
            "ĉiun",
            "ĉu",
            "ĝi",
            "ĝia",
            "ĝian",
            "ĝin",
            "ĝis",
            "ĵus",
            "ŝi",
            "ŝia",
            "ŝin"
        ));
    }
}
