/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.collection;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeIdGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"nitrite");
    private final SecureRandom random = new SecureRandom();
    private final long nodeIdBits = 10L;
    private long nodeId;
    private volatile long lastTimestamp = -1L;
    private volatile long sequence = 0L;
    private static final long no2epoch = 1288834974657L;

    public SnowflakeIdGenerator() {
        long maxNodeId = 1023L;
        this.nodeId = this.getNodeId();
        if (this.nodeId > maxNodeId) {
            log.warn("nodeId > maxNodeId; using random node id");
            this.nodeId = this.random.nextInt((int)maxNodeId) + 1;
        }
        log.debug("initialised with node id {}", (Object)this.nodeId);
    }

    protected long tillNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }

    protected long getNodeId() {
        byte[] uuid = this.asBytes(UUID.randomUUID());
        byte rndByte = (byte)(this.random.nextInt() & 0xFF);
        return (0xFFL & (long)uuid[uuid.length - 1] | 0xFF00L & (long)rndByte << 8) >> 6;
    }

    public synchronized long getId() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            log.warn("Clock moved backwards. Refusing to generate id for {} milliseconds.", (Object)(this.lastTimestamp - timestamp));
            try {
                Thread.sleep(this.lastTimestamp - timestamp);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        long sequenceBits = 12L;
        if (this.lastTimestamp == timestamp) {
            long sequenceMask = -1L << (int)sequenceBits ^ 0xFFFFFFFFFFFFFFFFL;
            this.sequence = this.sequence + 1L & sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tillNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        long timestampLeftShift = sequenceBits + 10L;
        long id = timestamp - 1288834974657L << (int)timestampLeftShift | this.nodeId << (int)sequenceBits | this.sequence;
        if (id < 0L) {
            log.warn("Generated id is negative: {}", (Object)id);
        }
        return id;
    }

    private byte[] asBytes(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }
}

