/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.collection.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.DocumentCursor;
import org.dizitart.no2.collection.FindOptions;
import org.dizitart.no2.collection.FindPlan;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.collection.operation.FindOptimizer;
import org.dizitart.no2.collection.operation.IndexOperations;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.processors.ProcessorChain;
import org.dizitart.no2.common.streams.BoundedStream;
import org.dizitart.no2.common.streams.ConcatStream;
import org.dizitart.no2.common.streams.DistinctStream;
import org.dizitart.no2.common.streams.DocumentStream;
import org.dizitart.no2.common.streams.FilteredStream;
import org.dizitart.no2.common.streams.IndexedStream;
import org.dizitart.no2.common.streams.SortedDocumentStream;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.filters.FieldBasedFilter;
import org.dizitart.no2.filters.Filter;
import org.dizitart.no2.filters.LogicalFilter;
import org.dizitart.no2.filters.NitriteFilter;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.index.NitriteIndexer;
import org.dizitart.no2.store.NitriteMap;

class ReadOperations {
    private final String collectionName;
    private final NitriteConfig nitriteConfig;
    private final NitriteMap<NitriteId, Document> nitriteMap;
    private final FindOptimizer findOptimizer;
    private final IndexOperations indexOperations;
    private final ProcessorChain processorChain;

    ReadOperations(String collectionName, IndexOperations indexOperations, NitriteConfig nitriteConfig, NitriteMap<NitriteId, Document> nitriteMap, ProcessorChain processorChain) {
        this.nitriteMap = nitriteMap;
        this.nitriteConfig = nitriteConfig;
        this.collectionName = collectionName;
        this.indexOperations = indexOperations;
        this.findOptimizer = new FindOptimizer();
        this.processorChain = processorChain;
    }

    public DocumentCursor find(Filter filter, FindOptions findOptions) {
        if (filter == null) {
            filter = Filter.ALL;
        }
        this.prepareFilter(filter);
        Collection<IndexDescriptor> indexDescriptors = this.indexOperations.listIndexes();
        FindPlan findPlan = this.findOptimizer.optimize(filter, findOptions, indexDescriptors);
        return this.createCursor(findPlan);
    }

    Document getById(NitriteId nitriteId) {
        Document document = this.nitriteMap.get(nitriteId);
        if (this.processorChain != null) {
            document = this.processorChain.processAfterRead(document);
        }
        return document;
    }

    private void prepareFilter(Filter filter) {
        if (filter instanceof NitriteFilter) {
            NitriteFilter nitriteFilter = (NitriteFilter)filter;
            this.prepareNitriteFilter(nitriteFilter);
            if (filter instanceof LogicalFilter) {
                LogicalFilter logicalFilter = (LogicalFilter)filter;
                this.prepareLogicalFilter(logicalFilter);
            }
        }
    }

    private void prepareNitriteFilter(NitriteFilter nitriteFilter) {
        nitriteFilter.setNitriteConfig(this.nitriteConfig);
        nitriteFilter.setCollectionName(this.collectionName);
    }

    private void prepareLogicalFilter(LogicalFilter logicalFilter) {
        List<Filter> filters = logicalFilter.getFilters();
        for (Filter filter : filters) {
            if (filter instanceof NitriteFilter) {
                NitriteFilter nitriteFilter = (NitriteFilter)filter;
                nitriteFilter.setObjectFilter(logicalFilter.getObjectFilter());
            }
            this.prepareFilter(filter);
        }
    }

    private DocumentCursor createCursor(FindPlan findPlan) {
        RecordStream<Pair<NitriteId, Document>> recordStream = this.findSuitableStream(findPlan);
        DocumentStream cursor = new DocumentStream(recordStream, this.processorChain);
        cursor.setFindPlan(findPlan);
        return cursor;
    }

    private RecordStream<Pair<NitriteId, Document>> findSuitableStream(FindPlan findPlan) {
        RecordStream<Pair<NitriteId, Document>> rawStream;
        if (!findPlan.getSubPlans().isEmpty()) {
            ArrayList<RecordStream<Pair<NitriteId, Document>>> subStreams = new ArrayList<RecordStream<Pair<NitriteId, Document>>>();
            for (FindPlan subPlan : findPlan.getSubPlans()) {
                RecordStream<Pair<NitriteId, Document>> suitableStream = this.findSuitableStream(subPlan);
                subStreams.add(suitableStream);
            }
            rawStream = new ConcatStream(subStreams);
            if (findPlan.isDistinct()) {
                rawStream = new DistinctStream(rawStream);
            }
        } else {
            if (findPlan.getByIdFilter() != null) {
                FieldBasedFilter byIdFilter = findPlan.getByIdFilter();
                NitriteId nitriteId = NitriteId.createId((String)byIdFilter.getValue());
                Document document = this.nitriteMap.get(nitriteId);
                rawStream = RecordStream.single(Pair.pair(nitriteId, document));
            } else {
                IndexDescriptor indexDescriptor = findPlan.getIndexDescriptor();
                if (indexDescriptor != null) {
                    NitriteIndexer indexer = this.nitriteConfig.findIndexer(indexDescriptor.getIndexType());
                    LinkedHashSet<NitriteId> nitriteIds = indexer.findByFilter(findPlan, this.nitriteConfig);
                    rawStream = new IndexedStream(nitriteIds, this.nitriteMap);
                } else {
                    rawStream = this.nitriteMap.entries();
                }
            }
            if (findPlan.getCollectionScanFilter() != null) {
                rawStream = new FilteredStream(rawStream, findPlan.getCollectionScanFilter());
            }
        }
        if (rawStream != null) {
            if (findPlan.getBlockingSortOrder() != null && !findPlan.getBlockingSortOrder().isEmpty()) {
                rawStream = new SortedDocumentStream(findPlan, rawStream);
            }
            if (findPlan.getLimit() != null || findPlan.getSkip() != null) {
                long limit = findPlan.getLimit() == null ? Long.MAX_VALUE : findPlan.getLimit();
                long skip = findPlan.getSkip() == null ? 0L : findPlan.getSkip();
                rawStream = new BoundedStream<NitriteId, Document>(skip, limit, rawStream);
            }
        }
        return rawStream;
    }
}

